<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Version details
 *
 * @package   theme_adaptable
 * @copyright 2015-2019 Jeremy Hopkins (Coventry University)
 * @copyright 2015-2019 Fernando Acedo (3-bits.com)
 * @copyright 2017-2019 Manoj Solanki (Coventry University)
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 *
 */

// General.
$string['choosereadme'] = '
<div class="clearfix">
<div class="well">
<h2>Adaptable</h2>
<p><img class="img-polaroid" src="adaptable/pix/screenshot.png" /></p>
</div>
<div class="well">
<h3>About</h3>
<p>Adaptable is a Moodle 2-columns responsive theme highly customizable and based in the popular BCU theme. Version 2 is using
 Boost as a base theme and therefore Bootstrap 4.</p>
<p>The theme is licensed under the GPL (GNU General Public License). You can find a complete licence copy <a href="http://www.gnu.org/licenses/" target="_HERE">blank</a></p>
<br>
<h4>Modify it! - Improve it! - Share it!</h4>
<br>
<h3>Credits</h3>
<p>This theme has been developed by:<br>
Jeremy Hopkins (Coventry University)<br>
Fernando Acedo (<a href="https://3-bits.com" target="_blank">3-bits.com</a>)</p>
Manoj Solanki (Coventry University)<br>
<br>
<h2>Other Credits</h2>
<p>In the development of version 2 they have also collaborated:<br>
Gareth J. Barnard (http://moodle.org/user/profile.php?id=442195)
Stuart Lamour
Alistair Spark (University College London)
<br>
<p>among many other developers, testers, translators and volunteers (See <a href="adaptable/README.txt" target="_blank">README.txt</a>)</p>
<br>
<h3>Bugs Report</h3>
<p>You can report bugs (and please, <b>ONLY</b> bugs) in our <a href="https://gitlab.com/3bits/moodle-theme_adaptable2" target="_blank">repository</a></p>
<br>
<h3>Technical Support</h3>
<p>You can ask your questions in the moodle forum:</p>
<ul>
<li>English: <a href="https://moodle.org/mod/forum/discuss.php?d=340404" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340404</a>
<li>Español: <a href="https://moodle.org/mod/forum/discuss.php?d=326804" target="_blank">https://moodle.org/mod/forum/discuss.php?d=326804</a>
<li>Català: <a href="https://moodle.org/mod/forum/discuss.php?d=340406" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340406</a>
</ul>
<br>
<h3>Demo</h3>
<p>You can see a demo version <a href="https://adaptable.ws/demo" target="_blank">HERE</a></p>
</div>
</div>';

$string['pluginname'] = 'Adaptable';
$string['configtitle'] = 'Adaptable';

$string['region-middle'] = 'Middle';
$string['region-frnt-footer'] = 'Footer';
$string['region-side-post'] = 'Right';
$string['region-side-pre'] = 'Left';
$string['frnt-footer'] = 'Blocks in this area will only be visible to admin users';
$string['side-post1'] = 'side bar in footer';

$string['region-frnt-market-a'] = 'Page region 1';
$string['region-frnt-market-b'] = 'Page region 2';
$string['region-frnt-market-c'] = 'Page region 3';
$string['region-frnt-market-d'] = 'Page region 4';
$string['region-frnt-market-e'] = 'Page region 5';
$string['region-frnt-market-f'] = 'Page region 6';
$string['region-frnt-market-g'] = 'Page region 7';
$string['region-frnt-market-h'] = 'Page region 8';
$string['region-frnt-market-i'] = 'Page region 9';
$string['region-frnt-market-j'] = 'Page region 10';
$string['region-frnt-market-k'] = 'Page region 11';
$string['region-frnt-market-l'] = 'Page region 12';
$string['region-frnt-market-m'] = 'Page region 13';
$string['region-frnt-market-n'] = 'Page region 14';
$string['region-frnt-market-o'] = 'Page region 15';
$string['region-frnt-market-p'] = 'Page region 16';
$string['region-frnt-market-q'] = 'Page region 17';
$string['region-frnt-market-r'] = 'Page region 18';
$string['region-frnt-market-s'] = 'Page region 19';
$string['region-frnt-market-t'] = 'Page region 20';

// Course page block regions.
$string['region-course-top-a'] = 'Course page top region 1';
$string['region-course-top-b'] = 'Course page top region 2';
$string['region-course-top-c'] = 'Course page top region 3';
$string['region-course-top-d'] = 'Course page top region 4';

$string['region-news-slider-a'] = 'Course page slider region';

$string['region-course-section-a'] = 'Course page activity end bottom region';

$string['region-course-bottom-a'] = 'Course page bottom region 5';
$string['region-course-bottom-b'] = 'Course page bottom region 6';
$string['region-course-bottom-c'] = 'Course page bottom region 7';
$string['region-course-bottom-d'] = 'Course page bottom region 8';

// Settings page headings ******************************************.
$string['settingsmaincolors'] = 'Main Colours';
$string['settingsheadercolors'] = 'Header Colours';
$string['settingsmobilecolors'] = 'Mobile Colours';
$string['settingsinfoboxcolors'] = 'Info Box Colours';
$string['settingssecondinfoboxcolors'] = 'Second Info Box Colours';
$string['settingsmarketingcolors'] = 'Marketing Block Colours';
$string['settingsoverlaycolors'] = 'Overlay Tiles Colours';
$string['settingsnavbarcolors'] = 'Navigation Bar (navbar) Colours';
$string['settingsalertbox'] = 'Alert Box';
$string['settingsbreadcrumbcolors'] = 'Breadcrumb Colours';
$string['settingsmessagescolors'] = 'Messages Pop-Up Colours';
$string['settingsfootercolors'] = 'Footer Colours';
$string['settingsfonts'] = 'Fonts';
$string['settingsanalytics'] = 'Analytics';
$string['settingsblocksgeneral'] = 'General';
$string['settingscolors'] = 'Colours';
$string['settingsborders'] = 'Borders';
$string['settingscourses'] = 'Courses';
$string['settingstopicsweeks'] = 'Topics / Weeks';
$string['settingsblockicons'] = 'Icons';

// Admin Menu Strings.
$string['blocksettings'] = 'Block Settings';
$string['frontpagealertsettings'] = 'Alert Box';
$string['frontpageblockregionsettings'] = 'Block Region Builder';
$string['dashboardblockregionsettings'] = 'Dashboard Block Region Builder';
$string['coursepageblockregionsettings'] = 'Course page Block Region Builder';
$string['frontpageblocksettings'] = 'Marketing Blocks';
$string['frontpagetickersettings'] = 'Frontpage Ticker';
$string['frontpageslidersettings'] = 'Frontpage Slider';
$string['frontpagecoursesettings'] = 'Frontpage Courses List';
$string['frontpagesettingsheading'] = 'Frontpage rendering';
$string['frontpagedesc'] = 'Configure the way that the course boxes are rendered on the frontpage.';
$string['frontpagerenderer'] = 'Frontpage Course Boxes';
$string['frontpagerendererdesc'] = 'Control the way that the coure boxes on the front page are rendered.';
$string['frontpagerendereroption1'] = 'Tiles';
$string['frontpagerendereroption2'] = 'Tiles w/ overlay';
$string['frontpagerendereroption3'] = 'Moodle default';
$string['frontpagerendereroption4'] = 'Coventry Tiles';


// Ticker **********************************************************.
$string['tickersettings'] = 'News Ticker';
$string['tickersettingsheading'] = 'Setup News Ticker on Front Page. See the layout <a href="./../theme/adaptable/pix/layout.png" target="_blank"> here</a>';
$string['tickerdesc'] = 'Here you can set a news ticker to run across the front page of your Moodle site.
  It is intended as a less intrusive alternative to the slider taking up very little space.
  To setup your ticker simply enter a paragraph list and include any hyperlinks you need to in that text.
  <strong>Note:</strong> If your ticker does not load properly switch to HTML view and ensure you have only p tags:
  <pre>
  &lt;p&gt;News item one.....&lt;/p&gt;
  &lt;p&gt;News item two.....&lt;/p&gt;
  </pre>';


$string['tickerdefault'] = 'No news items to display';

$string['enableticker'] = 'Enable the news ticker on the homepage?';
$string['enabletickerdesc'] = 'Check to enable the homepage ticker.';

$string['enabletickermy'] = 'Enable the news ticker on the My Home / Dashboard page?';
$string['enabletickermydesc'] = 'Check to enable the ticker on My Home / Dashboard.';

$string['enabletickerc'] = 'Enable the news ticker on internal pages?';
$string['enabletickercdesc'] = 'Check to enable the ticker on internal pages.';

$string['tickerwidth'] = 'News Ticker Width';
$string['tickerwidthdesc'] = 'You can use this setting to fix the news ticker at 100% width.';

$string['tickertextprofilefield'] = 'Custom Profile Field Name=Value (optional)';
$string['tickertextprofilefielddesc'] = 'Add access rule using for custom profile field eg: usertype=student';

$string['ticker'] = 'Announcements';

$string['tickerwidth'] = 'Fixed Width';
$string['tickerfullscreen'] = 'Full Screen width';

// Slideshow *******************************************************.
$string['slideshowsettings'] = 'Slideshow';
$string['slideshowsettingsheading'] = 'Customize the carousel on the front page. See the layout <a href="./../theme/adaptable/pix/layout.png" target="_blank"> here</a>';
$string['slideshowdesc'] = 'Upload the images, add the links and description for the carousel on the front page.';

$string['sliderimage'] = 'Slider Picture';
$string['sliderimagedesc'] = 'Add an image for your slide. Recommended size is 1600px x 400px or higher.';

$string['slidercaption'] = 'Slider Caption';
$string['slidercaptiondesc'] = 'Add a caption for your slide';

$string['sliderurl'] = 'Slide Link URL';
$string['sliderurldesc'] = 'Add a URL to which your slide links to when clicked.';

$string['slidermargintop'] = 'Margin above slider';
$string['slidermargintopdesc'] = 'Set the size of the margin above the slider.';

$string['slidermarginbottom'] = 'Margin below slider';
$string['slidermarginbottomdesc'] = 'Set the size of the margin below the slider.';

$string['sliderenabled'] = 'Enable Slider';
$string['sliderenableddesc'] = 'Enable a slider at the top of your home page';

$string['sliderfullscreen'] = 'Slider full screen';
$string['sliderfullscreendesc'] = 'Check this box to make the slider full screen (100% width)';

$string['slideroption2'] = 'Choose Slider Type';
$string['slideroption2desc'] = 'Choose Slider Type <strong>and then click SAVE</strong> to see colour settings for your chosen slider';

$string['slideroption2snippet'] = '<p>Sample HTML for Slider Captions:</p>
<pre>
&#x3C;div class=&#x22;span6 col-sm-6&#x22;&#x3E;
&#x3C;h3&#x3E;Hand-crafted&#x3C;/h3&#x3E; &#x3C;h4&#x3E;pixels and code for the Moodle community&#x3C;/h4&#x3E;
&#x3C;a href=&#x22;#&#x22; class=&#x22;submit&#x22;&#x3E;Please favorite our theme!&#x3C;/a&#x3E;
</pre>';

$string['slidercount'] = 'Slider Count';
$string['slidercountdesc'] = 'Select how many slides you want to add <strong>then click SAVE</strong> to load the input fields';

$string['sliderh3color'] = 'Slider 1 H3 Colour';
$string['sliderh3colordesc'] = 'Choose the colour you want for the slider 1 H3 tag';

$string['sliderh4color'] = 'Slider 1 H4 Colour';
$string['sliderh4colordesc'] = 'Choose the colour you want for the slider 1 H4 tag';

$string['slidersubmitcolor'] = 'Slider 1 Submit Text';
$string['slidersubmitcolordesc'] = 'Choose the text colour of the Slider 1 submit button';

$string['slidersubmitbgcolor'] = 'Slider 1 Submit bg';
$string['slidersubmitbgcolordesc'] = 'Choose the background colour of the Slider 1 submit button';

$string['slider2h3color'] = 'Slider 2 H3 Text Colour';
$string['slider2h3colordesc'] = 'Choose the text colour you want for the slider 2 H3 tag';

$string['slider2h4color'] = 'Slider 2 H4 Text Colour';
$string['slider2h4colordesc'] = 'Choose the text colour you want for the slider 2 H4 tag';

$string['slider2h3bgcolor'] = 'Slider 2 H3 bg Colour';
$string['slider2h3bgcolordesc'] = 'Choose the background colour you want for the slider 2 H3 tag';

$string['slider2h4bgcolor'] = 'Slider 2 H4 bg Colour';
$string['slider2h4bgcolordesc'] = 'Choose the background colour you want for the slider 2 H4 tag';

$string['slideroption2submitcolor'] = 'Slider 2 Submit Text';
$string['slideroption2submitcolordesc'] = 'Set a background colour for the submit text in slider style option 2 colour';

$string['slideroption2color'] = 'Slider 2 Submit bg';
$string['slideroption2colordesc'] = 'Set a background colour for the submit text in slider style option';

$string['slideroption2a'] = 'Slider style option 2 arrow background colour';
$string['slideroption2adesc'] = 'Set the slider style option 2 arrow background colour';

$string['sliderstyle1'] = 'Slider style 1';
$string['sliderstyle2'] = 'Slider style 2';


// Block Regions ***************************************************.
$string['blocklayoutbuilder'] = 'Frontpage Block Regions';
$string['blocklayoutbuilderdesc'] = 'Below you can build your own layout for block regions on the front page.
To add content these regions you will need to <strong> turn editing on on the front page of Moodle</strong>.
Then you can begin to drag/drop blocks into the regions you create!';

$string['dashblocklayoutbuilder'] = 'Dashboard Block Regions';
$string['dashblocklayoutbuilderdesc'] = 'Below you can build your own layout for block regions on the Dashboard page.
To add content these regions you will need to <strong> turn editing on, on the dashboard page of Moodle</strong>.
Then you can begin to drag/drop blocks into the regions you create!';

$string['coursepagesidebarinfooterenabledsection'] = 'Common settings';
$string['coursepagesidebarinfooterenabledsectiondesc'] = 'Common settings for most of the course formats.';

$string['coursepageblocklayoutbuilder'] = 'Course Page Block Regions';
$string['coursepageblocklayoutbuilderdesc'] = 'Below you can build your own layout for block regions on the course page.
To add content these regions you will need to <strong> turn editing on, on the course page of Moodle</strong>.
Then you can begin to drag/drop blocks into the regions you create!';

$string['blocklayoutlayoutcheck'] = 'Check your layout';
$string['blocklayoutlayoutcheckdesc'] = 'Use the tool below to check the number of blocks you have used and see a representation of your new layout.';
$string['blocklayoutlayoutcount1'] = 'You can set a maximum of ';
$string['blocklayoutlayoutcount2'] = ' block regions. You are currently using: ';

$string['blocklayoutlayoutrow'] = 'Block Region Row ';
$string['blocklayoutlayoutrowdesc'] = 'Add / set layout for block region row on front page.';

$string['dashblocklayoutlayoutrow'] = 'Dashboard Block Region Row ';
$string['dashblocklayoutlayoutrowdesc'] = 'Add / set layout for block region row on Dashboard page.';

$string['coursepageblocklayoutlayouttoprow'] = 'Course page Block Top Region Row ';
$string['coursepageblocklayoutlayouttoprowdesc'] = 'Add / set layout for block region row on Course page.';

$string['coursepageblocklayoutlayoutbottomrow'] = 'Course page Block Bottom Region Row ';
$string['coursepageblocklayoutlayoutbottomrowdesc'] = 'Add / set layout for block region row on Course page.';

$string['frontpageblocksenabled'] = 'Enable custom block region on front page';
$string['frontpageblocksenableddesc'] = 'You can enable / disable custom block regions on the front page.
You can then drag and drop blocks into the regions you created';

$string['dashblocksenabled'] = 'Enable custom block region on Dashboard page';
$string['dashblocksenableddesc'] = 'You can enable / disable custom block regions on the Dashboard page.
You can then drag and drop blocks into the regions you created';

$string['dashblocksposition'] = 'Custom block region position';
$string['dashblockspositiondesc'] = 'When custom block regions are enabled for the dashboard page, choose the position.';
$string['dashblocksabovecontent'] = 'Show above main content';
$string['dashblocksbelowcontent'] = 'Show below main content';

$string['coursepageblocksenabled'] = 'Enable custom block regions on Course page';
$string['coursepageblocksenableddesc'] = 'You can enable / disable custom block regions (top and bottom) on the Course page.
You can then drag and drop blocks into the regions you created';

$string['coursepagenewssliderblockregionheading'] = 'Custom news slider block region';
$string['coursepagenewssliderblockregionheadingdesc'] = 'A custom block region designed for use with the news slider that is part of Adaptable UI. This region appears above course activities on a Course page.  To add news slider block, first install the <strong><a href="https://moodle.org/plugins/block_news_slider">Adaptable UI news slider</a></strong> and configure it to appear in the region "course page slider region" on all course pages.';

$string['coursepageblocksliderenabled'] = 'Enable custom slider block region on Course page';
$string['coursepageblocksliderenableddesc'] = 'Enable this region on all course pages.';

$string['coursepageactivitybottomblockregionheading'] = 'Custom course activity bottom block region';
$string['coursepageactivitybottomblockregionheadingdesc'] = 'A custom block region that appears after the end of activities.';

$string['coursepageblockactivitybottomenabled'] = 'Enable course activity bottom block region on course page';
$string['coursepageblockactivitybottomenableddesc'] = 'Enable this region on all course pages.';

$string['coursepagesidebarinfooterenabled'] = 'Move sidebar to footer on Course page';
$string['coursepagesidebarinfooterenableddesc'] = 'Wide course page layout by moving sidebar to footer.';

$string['layoutcheck'] = 'Check your layout';
$string['layoutcheckdesc'] = 'Use the tool below to check the number of blocks you have used and see a representation of your new layout.';
$string['layoutcount1'] = 'You can set a maximum of ';
$string['layoutcount2'] = ' block regions. You are currently using: ';

$string['sidebaricon'] = 'Show / hide the sidebar';

// Marketing Blocks & Info Box *************************************.
$string['marketingsettings'] = 'Marketing Blocks';
$string['marketingsettingsheading'] = 'Customize the marketing blocks that appear on the front page. See the layout <a href="./../theme/adaptable/pix/layout.png" target="_blank"> here</a>';
$string['marketingdesc'] = 'There are two full width info boxes with differing styles you can use.
In addition to this there is a layout builder allowing you to decide how many blocks you need and define your own layout, please see the <a href="./../theme/adaptable/README.txt" target="_blank">README</a> file that comes with this theme.';

$string['marketingbuilderheading'] = 'Marketing Block Layout Builder';
$string['marketingbuilderdesc'] = 'Use the tool below to setup your marketing blocks. Once defined the block settings will appear further down the page.';

$string['marketlayoutrow'] = 'Marketing Block Row';
$string['marketlayoutrowdesc'] = 'Add / set layout for marketing block row on front page';

$string['market'] = 'Marketing Block ';
$string['marketdesc'] = 'Add html for marketing block (see the <a href="./../theme/adaptable/README.txt" target="_blank">README</a> file for additional info and hints).';

$string['layoutaddcontent'] = 'Happy With Your Layout? Now Add Content to Your Blocks:';
$string['layoutaddcontentdesc1'] = 'You have configured ';
$string['layoutaddcontentdesc2'] = ' marketing blocks. If you are happy with this layout add content to the blocks below.
If you are not happy use the layout builder above to make changes<br />';

$string['infobox'] = 'Frontpage Info Box';
$string['infoboxdesc'] = 'Frontpage info block HTML (see the <a href="./../theme/adaptable/README.txt" target="_blank">README</a> file for additional info and hints).<br><br><strong>Note: </strong><i>This element is only used for compatibility with BCU and will be removed in coming versions.</i>';

$string['infoboxfullscreen'] = 'Make infobox full screen';
$string['infoboxfullscreendesc'] = 'Turning this option on will make the infobox full screen.';

$string['infobox2'] = 'Frontpage Secondary Info Box';
$string['infobox2desc'] = 'Frontpage Secondary Info Box (see the <a href="./../theme/adaptable/README.txt" target="_blank">README</a> file for additional info and hints).<br><br><strong>Note: </strong><i>This element is only used for compatibility with BCU and will be removed in coming versions.</i>';

$string['frontpagemarketenabled'] = 'Enable Marketing Blocks';
$string['frontpagemarketenableddesc'] = 'Set the marketing blocks in the frontpage.';

$string['frontpagemarketoption'] = 'Choose style for marketing blocks';
$string['frontpagemarketoptiondesc'] = 'You can apply different styles to marketing blocks.
Note: BCU style is designed to work with images at top of block.';

$string['bcustyle'] = 'BCU style';
$string['coventrystyle'] = 'Coventry style';
$string['nostyle'] = 'No style';
$string['disabled'] = 'Disabled';
$string['expandable'] = 'Expandable';
$string['static'] = 'Static';


// Footer **********************************************************.
$string['footersettings'] = 'Footer';
$string['footersettingsheading'] = 'Set the content that should appear in the footer. See the layout <a href="./../theme/adaptable/pix/layout.png" target="_blank"> here</a> ';

$string['footerdesc'] = 'Control the content that appears in the 4 footer sections of the page.';

$string['showfooterblocks'] = 'Show Footnote Block';
$string['showfooterblocksdesc'] = 'Show / hide the lower footerblock used for footnote / Moodle docs region';

$string['footerblocksplacement'] = 'Footer Blocks Placement ';
$string['footerblocksplacementdesc'] = 'Control where the upper footer blocks are displayed. Sitewide is default.';
$string['footerblocksplacement1'] = 'Sitewide';
$string['footerblocksplacement2'] = 'Homepage Only';
$string['footerblocksplacement3'] = 'Never';

$string['footerlayoutrow'] = 'Footer Layout Builder';
$string['footerlayoutrowdesc'] = 'Design your layout for footer block regions.';

$string['footnote'] = 'Footnote';
$string['footnotedesc'] = 'Add text to the footer.';

$string['footerheader'] = 'Footer Title Section ';
$string['footerdesc'] = 'Add a title for footer section ';

$string['footercontent'] = 'Footer Content Section ';
$string['footercontentdesc'] = 'Add content to footer section ';

$string['hidefootersocial'] = 'Show social icons';
$string['hidefootersocialdesc'] = 'Show social icons in the footer below the blocks.';

// Data Retention Summary Button.
$string['gdprbutton'] = 'Data Retention Summary button';
$string['gdprbuttondesc'] = 'Display the Data Retention Summary button in the footer.';

// Moodle Docs link.
$string['moodledocs'] = 'Moodle Docs link';
$string['moodledocsdesc'] = 'Display the Moodle Docs link in the footer.';


// NavBar **********************************************************.
$string['stickynavbar'] = 'Sticky Navbar at the top';
$string['stickynavbardesc'] = 'Stick the Navbar at the top of the screen when scrolling down.';

$string['navbarcachetime'] = 'Navbar Cache Time';
$string['navbarcachetimedesc'] = 'The number of minutes the navigation bar is cached for.';

$string['navbarmenusettings'] = 'Navbar Custom Menu';
$string['navbarmenusettingsheading'] = 'Customize the menu in the navigation bar. See the layout <a href="./../theme/adaptable/pix/layout.png" target="_blank"> here</a>.';
$string['navbarmenusettingsdesc'] = 'Allows you to add a menu to the navigation bar.';

$string['navbarsettings'] = 'Navbar Settings';
$string['navbarsettingsheading'] = 'Customize the navigation bar';
$string['navbardesc'] = 'Allows you to control all of the elements that appear on the navigation bar.';

$string['navbarstyles'] = 'Navbar Styles';
$string['navbarstylesheading'] = 'Customize the navigation bar styles';
$string['navbarstylesdesc'] = 'Allows you to control the styles of the elements that appear on the navigation bar.';

$string['navbarlinkssettings'] = 'Navbar Links';
$string['navbarlinksettingsheading'] = 'Customize the links on the navigation bar';
$string['navbarlinksettingsdesc'] = 'Allows you to control the links that appear on the navigation bar.';

$string['navbardisplayicons'] = 'Display icons';
$string['navbardisplayiconsdesc'] = 'Display icons next to main menu headings';

$string['navbardisplaysubmenuarrow'] = 'Display sub-menu arrow';
$string['navbardisplaysubmenuarrowdesc'] = 'Display sub-menu arrow (downward facing) when a menu heading has sub-menu options.';

$string['home'] = 'Home';
$string['enablemy'] = 'Dashboard';
$string['enablemydesc'] = 'Display a link to the Dashboard page';

$string['enableprofile'] = 'User Profile';
$string['enableprofiledesc'] = 'Display a link to the users profile';

$string['enableeditprofile'] = 'Edit Profile';
$string['enableeditprofiledesc'] = 'Display a link to edit the users profile';

$string['enablebadges'] = 'Badges';
$string['enablebadgesdesc'] = 'Display a link to the users badges';

$string['enablegrades'] = 'Grades';
$string['enablegradesdesc'] = 'Display a link to the users grades';

$string['enablecalendar'] = 'User Calendar';
$string['enablecalendardesc'] = 'Display a link to the users calendar';

$string['enableprivatefiles'] = 'Private Files';
$string['enableprivatefilesdesc'] = 'Display a link to the users private files';

$string['enablesearchbox'] = 'Enable Search Box';
$string['enablesearchboxdesc'] = 'Display a search box in the header';

$string['searchcourses'] = 'Search Courses';

$string['enablepref'] = 'My Preferences';
$string['enableprefdesc'] = 'Display a link to the user preferences page';

$string['enablenote'] = 'My Notifications';
$string['enablenotedesc'] = 'Display a link to the user notifications page';

$string['enableblog'] = 'Enable My blogs';
$string['enableblogdesc'] = 'Display a link to the users blogs page';

$string['enableposts'] = 'My Posts';
$string['enablepostsdesc'] = 'Display a link to the my posts page';

$string['enablefeed'] = 'My Feedback';
$string['enablefeeddesc'] = 'Display a link to the users "My Feedback" page - Note: this requires the <a href="https://moodle.org/plugins/report_myfeedback" target="blank">My Feedback Plugin</a>';

$string['enableaccesstool'] = 'Accessibility Tool';
$string['enableaccesstooldesc'] = 'Display a link to the users "Accessibility Tool" Preferences page - Note: this requires the <a href="https://github.com/sharpchi/moodle-local_accessibilitytool" target="blank">Accessibility Tool Plugin</a>';

$string['myblogs'] = 'My Blogs';

$string['noenrolments'] = 'No enrolments found.';

$string['enablemyhomedesc'] = 'Display a link to {$a}';
$string['enableeventsdesc'] = 'Display a link to the calendar';

$string['enablethiscoursedesc'] = 'Display a dropdown with activities from the current course.';
$string['enablecoursesectionsdesc'] = 'Display a sub-menu on the \'This course\' menu containing links to each shown section.';
$string['sections'] = 'Sections';

$string['enablecompetencieslink'] = 'Competencies link';
$string['enablecompetencieslinkdesc'] = 'Display competencies link in the \'This course\' menu.  Note: \'core_competency|enabled\' needs to be ticked.';


// Navbar styling *********************************************************.
$string['navbardropdownborderradius'] = 'Dropdown menu border radius';
$string['navbardropdownborderradiusdesc'] = 'Controls the border radius for dropdown menus (e.g. rounded corners).';
$string['navbardropdownhovercolor'] = 'Dropdown menu background hover colour';
$string['navbardropdownhovercolordesc'] = 'Dropdown menu background colour when hovering over menu items.';
$string['navbardropdowntextcolor'] = 'Dropdown menu text colour';
$string['navbardropdowntextcolordesc'] = 'Dropdown menu item text colour.';
$string['navbardropdowntexthovercolor'] = 'Dropdown menu text hover colour';
$string['navbardropdowntexthovercolordesc'] = 'Dropdown menu text colour when hovering over menu items.';
$string['navbardropdowntransitiontime'] = 'Navbar transition time';
$string['navbardropdowntransitiontimedesc'] = 'Navbar transition effect time in seconds.  Provides a fade-in animation effect when hovering over a menu that has sub-menus.';

// This Course menu *********************************************************.
$string['enablemysitesdesc'] = 'Display a dropdown with the course activities and other options';
$string['headernavbarthiscourseheading'] = 'This Course Menu';
$string['headernavbarthiscourseheadingdesc'] = 'In this menu the student can access directly all the course activities and the participants list and his grades.';

$string['displayparticipants'] = 'Display Participants';
$string['displayparticipantsdesc'] = 'Display the Participants item in the menu';
$string['displaygrades'] = 'Display Grades';
$string['displaygradesdesc'] = 'Display the Grades item in the menu';

// My courses menu *********************************************************.
$string['enablemysitesdesc'] = 'Display a dropdown with a users courses';
$string['headernavbarmycoursesheading'] = 'My Courses Menu';
$string['headernavbarmycoursesheadingdesc'] = 'All options for the My Courses (My Sites) menu option that displays list of current user&#39;s courses';

$string['enablemysitesrestriction'] = 'Restrict user&#39;s courses dropdown to a custom profile field';
$string['enablemysitesrestrictiondesc'] = 'Restrict dropdown with a user&#39;s courses by custom profile field. E.g. usertype=staff';

$string['mysitessortoverride'] = 'Enable My Courses Custom Sort';
$string['mysitessortoverridedesc'] = 'Use custom profile fields or generic strings (year etc) to collapse past courses in sub menu';
$string['mysitessortoverridefield'] = 'My Courses Custom Profile Field(s) or Strings';
$string['mysitessortoverridefielddesc'] = 'Comma delimited list of profile fields or strings to check for in course short codes';

$string['mysitessortoverrideoff'] = 'Display all enrolled courses in single flat list';
$string['mysitessortoverridestrings'] = 'Display enrolled containing strings in first list, others in sub menu';
$string['mysitessortoverrideprofilefields'] = 'Display courses found in profile fields in first list, others in sub menu';
$string['mysitessortoverrideprofilefieldscohort'] = 'Display courses found in profile fields + cohorts in first list, others in sub menu';
$string['mysitessortoverridemyoverview'] = 'Use list from my overview';
$string['mysitessortoverridelast'] = 'Last accessed time or enrolment start time if never accessed';

$string['mysitesmaxlength'] = 'My Courses Max Length';
$string['mysitesmaxlengthdesc'] = 'Adjust the max length of coursenames in the My Courses dropdown to optimise for your font.';

$string['mycoursesmenulimit'] = 'My Courses Menu Limit';
$string['mycoursesmenulimitdesc'] = 'Adjust the max number of courses that appear in the My Courses dropdown. 0 will show all courses.';

$string['mysitesmenudisplay'] = 'My Courses Menu Display';
$string['mysitesmenudisplaydesc'] = 'Choose what text to display for a menu item and on hover.';
$string['mysitesmenudisplayshortcodenohover'] = 'Show short code and no text on hover.';
$string['mysitesmenudisplayshortcodefullnameonhover'] = 'Show short code and full course name on hover.';
$string['mysitesmenudisplayfullnamenohover'] = 'Show full course title and no text on hover.';
$string['mysitesmenudisplayfullnamefullnameonhover'] = 'Show full course title and full title on hover.';

$string['enablehomedesc'] = 'Display a link to the frontpage.';

$string['enablehomeredirect'] = 'Enable Home redirect=0';
$string['enablehomeredirectdesc'] = 'Enable redirect=0 on home. This is for use on sites where where My Home is default homepage. It prevents users clicking the Home link from being redirected back to My Home / Dashboard';

$string['chiddenicon'] = 'My courses hidden icon';
$string['chiddenicondesc'] = 'The Font Awesome 4 icon without the prefixing \'fa-\' to be used for hidden courses.  If empty, the default will be used.';
$string['cfrozenicon'] = 'My courses frozen icon';
$string['cfrozenicondesc'] = 'The Font Awesome 4 icon without the prefixing \'fa-\' to be used for frozen courses.  If empty, the default will be used.';
$string['cneveraccessedicon'] = 'My courses never accessed icon';
$string['cneveraccessedicondesc'] = 'The Font Awesome 4 icon without the prefixing \'fa-\' to be used for courses that the user is enrolled on but not accessed.  If empty, the default will be used.';
$string['cdefaulticon'] = 'My courses default icon';
$string['cdefaulticondesc'] = 'The Font Awesome 4 icon without the prefixing \'fa-\' to be used for courses when they don\'t already have an icon.  If empty, the default will be used.';


// Colours *********************************************************.
$string['colorsettings'] = 'Colours';
$string['colorsettingsheading'] = 'Modify the main colours used throughout the theme.';
$string['colordesc'] = 'You can select the colours that you would like to use throughout the theme. Use Hex or any other standard notation. As an alternate option you can use transparent and inherited as a value';
$string['linkcolor'] = 'Link Colour';
$string['linkcolordesc'] = 'Set the colour of links in the theme, use html hex code.';

$string['linkhover'] = 'Link Hover colour';
$string['linkhoverdesc'] = 'Set the colour of links (on hover) in the theme, use html hex code.';

$string['backcolor'] = 'Background colour';
$string['backcolordesc'] = 'Set the background colour.';

$string['regionmaincolor'] = 'Main region colour';
$string['regionmaincolordesc'] = 'Set the background colour for main content area.';

$string['maincolor'] = 'Main colour';
$string['maincolordesc'] = 'Main colour for blocks and footer.';

$string['footertextcolor'] = 'Footer text colour';
$string['footertextcolordesc'] = 'The colour of the text in the footer, use html hex code.';

$string['footerbkcolor'] = 'Footer background colour';
$string['footerbkcolordesc'] = 'Set the footer background colour.';

$string['footertextcolor2'] = 'Lower footer text colour';
$string['footertextcolor2desc'] = 'Lower footer text colour.';

$string['footerlinkcolor'] = 'Footer blocks link colour';
$string['footerlinkcolordesc'] = 'Footer blocks link colour.';

$string['headerbkcolor'] = 'Top header background colour';
$string['headerbkcolordesc'] = 'Set the top header background colour.';

$string['msgbadgecolor'] = 'Message badge background colour';
$string['msgbadgecolordesc'] = 'Set the background colour for the messages badge / bubble in the header (displays number of unread messages)';

$string['messagingbackgroundcolor'] = 'Messages main window background colour';
$string['messagingbackgroundcolordesc'] = 'Set the background colour for the messages main chat window.';

$string['headerbkcolor2'] = 'Lower header background colour';
$string['headerbkcolor2desc'] = 'Set the lower header background colour. Note that this also sets the colour for the background in Header style 2.';

$string['headertextcolor'] = 'Top Header blocks text and link colour';
$string['headertextcolordesc'] = 'Set the top header blocks text and link colour.';

$string['headertextcolor2'] = 'Lower Header blocks text and link colour';
$string['headertextcolor2desc'] = 'Set the lower header blocks text and link colour.';

$string['blockheadercolor'] = 'Block header font colour';
$string['blockheadercolordesc'] = 'Set the block header font colour.';

$string['blockbackgroundcolor'] = 'Block background colour';
$string['blockbackgroundcolordesc'] = 'Set the background colour for all blocks.';

$string['blockheaderbackgroundcolor'] = 'Block heading background colour';
$string['blockheaderbackgroundcolordesc'] = 'Set the heading background colour for all blocks.';

$string['blockbordercolor'] = 'Block border colour';
$string['blockbordercolordesc'] = 'Set the block border colour.';

$string['blockregionbackground'] = 'Block Region Backround Colour';
$string['blockregionbackgrounddesc'] = 'Background colour of container holding custom block layouts on the front page';

$string['blockheaderbordertop'] = 'Block header top border thickness';
$string['blockheaderbordertopdesc'] = 'Set the thickness of the top border of block headers';

$string['blockheaderborderleft'] = 'Block header left border thickness';
$string['blockheaderborderleftdesc'] = 'Set the thickness of the left hand border of block headers';

$string['blockheaderborderright'] = 'Block header right border thickness';
$string['blockheaderborderrightdesc'] = 'Set the thickness of the right hand border of block headers';

$string['blockheaderborderbottom'] = 'Block header bottom border thickness';
$string['blockheaderborderbottomdesc'] = 'Set the thickness of the bottom border of block headers';

$string['blockmainbordertop'] = 'Block main top border thickness';
$string['blockmainbordertopdesc'] = 'Set the thickness of the top border of the main block area';

$string['blockmainborderleft'] = 'Block main left border thickness';
$string['blockmainborderleftdesc'] = 'Set the thickness of the left hand border of the main block area';

$string['blockmainborderright'] = 'Block main right border thickness';
$string['blockmainborderrightdesc'] = 'Set the thickness of the right hand border of the main block area';

$string['blockmainborderbottom'] = 'Block main bottom border thickness';
$string['blockmainborderbottomdesc'] = 'Set the thickness of the bottom border of the main block area';

$string['blockheaderbordertopstyle'] = 'Block header border style';
$string['blockheaderbordertopstyledesc'] = 'Set the style of the border of block headers';

$string['blockmainbordertopstyle'] = 'Block Main border style';
$string['blockmainbordertopstyledesc'] = 'Set the style of the border of block content area';

$string['blockheadertopradius'] = 'Block header top radius';
$string['blockheadertopradiusdesc'] = 'Set the radius of top header block to achieve a curved / rounded effect';

$string['blockheaderbottomradius'] = 'Block header bottom radius';
$string['blockheaderbottomradiusdesc'] = 'Set the radius of bottom header block to achieve a curved / rounded effect';

$string['blockmaintopradius'] = 'Block main top radius';
$string['blockmaintopradiusdesc'] = 'Set the top radius of main block area to achieve a curved / rounded effect';

$string['blockmainbottomradius'] = 'Block main bottom radius';
$string['blockmainbottomradiusdesc'] = 'Set the bottom radius of main block area to achieve a curved / rounded effect';

$string['marketblockbordercolor'] = 'Marketing block border line colour';
$string['marketblockbordercolordesc'] = 'Set the marketing block border line colour';

$string['marketblocksbackgroundcolor'] = 'Marketing blocks region background colour';
$string['marketblocksbackgroundcolordesc'] = 'Set the Marketing blocks region background colour.';

$string['sectionheadingcolor'] = 'Section Heading Text Colour';
$string['sectionheadingcolordesc'] = 'Set the colour for section headings text';

$string['collapsedtopicscoloursenabled'] = 'Collapsed Topics toggle fore and backgound colour settings';
$string['collapsedtopicscoloursenableddesc'] = 'Use Collapsed Topics fore and bacground colour settings instead of Adaptable\'s \'sectionheadingcolor\' and \'coursesectionheaderbg\' settings.';

$string['homebk'] = 'Frontpage Background Image';
$string['homebkdesc'] = 'Upload an image that will be a background image on the homepage.';

$string['editonbk'] = 'Editing and Customize this page button background';
$string['editonbkdesc'] = 'Set the background colour for the editing and customize this page button';

$string['editoffbk'] = 'Editing and Customize this page OFF button background';
$string['editoffbkdesc'] = 'Set the background colour for the editing and customize this page button in OFF state.';

$string['dividingline'] = 'Dividing line in header';
$string['dividinglinedesc'] = 'The colour for the dividing line found in the header';

$string['dividingline2'] = 'Dividing line in footer';
$string['dividingline2desc'] = 'The colour for the dividing line found in the footer';

$string['breadcrumbbackgroundcolor'] = 'Breadcrumb background colour';
$string['breadcrumbbackgroundcolordesc'] = 'Set the background colour of the breadcrumb.';

$string['breadcrumbtextcolor'] = 'Breadcrumb text colour';
$string['breadcrumbtextcolordesc'] = 'Set the text colour of the breadcrumb.';

$string['activebreadcrumb'] = 'Active breadcrumb background colour';
$string['activebreadcrumbdesc'] = 'Set the background colour of the active breadcrumb colour, and remainder of the breadcrumb bar.';

$string['messagepopupbackground'] = 'Messages pop-up background colour';
$string['messagepopupbackgrounddesc'] = 'Set the background colour of messages pop-up header.';

$string['messagepopupcolor'] = 'Messages pop-up text colour';
$string['messagepopupcolordesc'] = 'Set the text colour of messages pop-up header.';

$string['menubkcolor'] = 'Main Menu background colour';
$string['menubkcolordesc'] = 'Set a Main Menu background colour';

$string['menubordercolor'] = 'Main Menu bottom border colour';
$string['menubordercolordesc'] = 'Set a Main Menu border bottom colour';

$string['menufontcolor'] = 'Main Menu font colour';
$string['menufontcolordesc'] = 'Set a Main Menu font colour';

$string['menuhovercolor'] = 'Main Menu hover colour';
$string['menuhovercolordesc'] = 'Set a Main Menu hover colour';

$string['mobilemenubkcolor'] = 'Mobile Menu background colour';
$string['mobilemenubkcolordesc'] = 'Set the Main Menu background colour on mobile devices (collapsed)';

$string['mobileslidebartabbkcolor'] = 'Sidebar tab background colour';
$string['mobileslidebartabbkcolordesc'] = 'The sidebar background colour on mobile devices (collapsed)';

$string['mobileslidebartabiconcolor'] = 'Sidebar tab icon colour';
$string['mobileslidebartabiconcolordesc'] = 'The sidebar icon colour on mobile devices (collapsed)';

$string['selectiontext'] = 'Selection text colour';
$string['selectiontextdesc'] = 'Set the text colour when a text in the screen is selected.';

$string['selectionbackground'] = 'Selection background colour';
$string['selectionbackgrounddesc'] = 'Set the background colour when a text in the screen is selected.';

// Course Formats *********************************************************.
$string['coursesettings'] = 'Course Formats';
$string['coursesettingsheading'] = 'Course Formats Settings';
$string['coursesettingsdesc'] = 'Customize some of the most used Moodle course formats to fit the main design.';

// Common settings.
$string['commonlyusedar'] = 'Commonly used activities and resources';
$string['commonlyusedardesc'] = 'Use this box to specifiy the list of activity/resource names (comma separated) you wish to see at the top of the module chooser.  Current possible names are {$a}.';
$string['commonlyusedartitle'] = 'Commonly used activities and resources';

$string['showyourprogress'] = 'Show &#39;Your Progress&#39; label ';
$string['showyourprogressdesc'] = 'Show / hide the &#39;Your Progress&#39; label in the top of the course content. This label is only for information purposes and can be hidden. ';

// Course Section background color.
$string['coursesectionbgcolor'] = 'Course Section Background';
$string['coursesectionbgcolordesc'] = 'Set the background colour of the course section.';

// Topics / Weeks Settings.
$string['topicsweeks'] = 'Topics/Weeks course format';
$string['topicsweeksdesc'] = 'Set styles for the Topics/Weeks course format';

$string['coursesectionheaderbg'] = 'Course Section Header Background';
$string['coursesectionheaderbgdesc'] = 'Set the background colour of the course section headers';

$string['currentcolor'] = 'Current Course Section Highlight Colour';
$string['currentcolordesc'] = 'Set the colour for the current course section highlight';

$string['coursesectionheaderborderstyle'] = 'Course Section Header Border Style';
$string['coursesectionheaderborderstyledesc'] = 'Set the style of the course section header border (only bottom border is used as outer container also has border)';

$string['coursesectionheaderbordercolor'] = 'Course Section Header Border Colour';
$string['coursesectionheaderbordercolordesc'] = 'Set the colour of the course section header border (only bottom border is used as outer container also has border)';

$string['coursesectionheaderborderwidth'] = 'Course Section Header Border Width';
$string['coursesectionheaderborderwidthdesc'] = 'Set the width of the course section header border (only bottom border is used as outer container also has border)';

$string['coursesectionheaderborderradiustop'] = 'Course Header Section Border Radius Top';
$string['coursesectionheaderborderradiustopdesc'] = 'Set the top radius of course section header borders (rounded corners)';

$string['coursesectionheaderborderradiusbottom'] = 'Course Header Section Border Radius Bottom';
$string['coursesectionheaderborderradiusbottomdesc'] = 'Set the bottom radius of course section header borders (rounded corners)';

$string['coursesectionborderstyle'] = 'Course section border style';
$string['coursesectionborderstyledesc'] = 'Set the border style of course sections';

$string['coursesectionborderwidth'] = 'Course Section Border Width';
$string['coursesectionborderwidthdesc'] = 'Set the width of course section borders';

$string['coursesectionbordercolor'] = 'Course Section Border Colour';
$string['coursesectionbordercolordesc'] = 'Set the border colour of course sections';

$string['coursesectionborderradius'] = 'Course Section Border Radius';
$string['coursesectionborderradiusdesc'] = 'Set the radius of course section borders (rounded corners)';

// Course section activity styling.
$string['coursesectionactivityuseadaptableicons'] = 'Use Adaptable Icon Set';
$string['coursesectionactivityuseadaptableiconsdesc'] = 'Turn this on to use Adaptable icons. If turned off, please also ensure you remove the directories adaptable/pix_plugins and adaptable/pix_core/f to use default Moodle icons.';

$string['coursesectionactivityiconsize'] = 'Course Section Activity Icon Size';
$string['coursesectionactivityiconsizedesc'] = 'Set the icon size for activities / recursos (e.g. a value of 16px will set it at 16px x 16px).';

$string['coursesectionactivityheadingcolour'] = 'Course Section Activity Heading Colour';
$string['coursesectionactivityheadingcolourdesc'] = 'The colour for clickable activities displayed on the course homepage.';

// These four settings actually refer to bottom border (it was originally all around border, but naming kept as it was originally).
$string['coursesectionactivityborderwidth'] = 'Course Section Activity Bottom Border Width';
$string['coursesectionactivityborderwidthdesc'] = 'Set width of the border that appears at the bottom of a course section activity.';
$string['coursesectionactivityborderstyle'] = 'Course Section Activity Bottom Border Style';
$string['coursesectionactivityborderstyledesc'] = 'Set the style of the course section activity bottom border.';
$string['coursesectionactivitybordercolor'] = 'Course Section Activity Bottom Border Colour ';
$string['coursesectionactivitybordercolordesc'] = 'Set the colour of the course section activity bottom border.';
$string['coursesectionactivityleftborderwidth'] = 'Course Section Activity Left Border Width';
$string['coursesectionactivityleftborderwidthdesc'] = 'Set width of the border that appears on the left of a course section activity.';

$string['coursesectionactivitycolors'] = 'Course Section Activity Options';

$string['coursesectionactivityassignleftbordercolor'] = 'Assignment activity left border display colour';
$string['coursesectionactivityassignleftbordercolordesc'] = 'Set the colour of the left border.';
$string['coursesectionactivityassignbgcolor'] = 'Assignment activity background colour';
$string['coursesectionactivityassignbgcolordesc'] = 'Set the Assignment activity background colour. Type <strong>transparent</strong> in the box for transparency.';

$string['coursesectionactivityforumleftbordercolor'] = 'Forum activity left border display colour';
$string['coursesectionactivityforumleftbordercolordesc'] = 'Set the colour of the left border.';
$string['coursesectionactivityforumbgcolor'] = 'Forum activity background colour';
$string['coursesectionactivityforumbgcolordesc'] = 'Set the Forum activity background colour. Type <strong>transparent</strong> in the box for transparency.';

$string['coursesectionactivityquizleftbordercolor'] = 'Quiz activity left border display colour';
$string['coursesectionactivityquizleftbordercolordesc'] = 'Set the colour of the left border.';
$string['coursesectionactivityquizbgcolor'] = 'Quiz activity background colour';
$string['coursesectionactivityquizbgcolordesc'] = 'Set the Quiz activity background colour. Type <strong>transparent</strong> in the box for transparency.';

// Social Wall Settings.
$string['socialwall'] = 'Social Wall';
$string['socialwallheading'] = 'Social Wall Settings';
$string['socialwalldesc'] = 'Customise the appearance of the <a href="https://moodle.org/plugins/format_socialwall">Social Wall Course Format</a> (if in use on your site)';

$string['socialwallbackgroundcolor'] = 'Background colour';
$string['socialwallbackgroundcolordesc'] = 'The background colour of a Social Wall course.';

$string['socialwallsectionradius'] = 'Border radius';
$string['socialwallsectionradiusdesc'] = 'The border radius of Social Wall sections.';

$string['socialwallbordertopstyle'] = 'Border style';
$string['socialwallbordertopstyledesc'] = 'The border style of Social Wall sections.';

$string['socialwallborderwidth'] = 'Border width';
$string['socialwallborderwidthdesc'] = 'The border width of Social Wall sections.';

$string['socialwallbordercolor'] = 'Border colour';
$string['socialwallbordercolordesc'] = 'The border colour of Social Wall sections.';

$string['socialwallactionlinkcolor'] = 'Action link colour';
$string['socialwallactionlinkcolordesc'] = 'The colour of action links in Social Wall.';

$string['socialwallactionlinkhovercolor'] = 'Action link hover colour';
$string['socialwallactionlinkhovercolordesc'] = 'The colour of action links when hovered in Social Wall.';

// Blocks General **************************************************.
$string['shownavigationblockoncoursepage'] = 'Show Navigation Block on course page';
$string['shownavigationblockoncoursepagedesc'] = 'Set this to show the navigation block on the course page.';

// Fonts ***********************************************************.
$string['fontsettings'] = 'Fonts';
$string['fontsettingsheading'] = 'Modify the fonts used throughout the theme.';
$string['fontdesc'] = 'You can select the <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> that you would like to use throughout the theme. Select the subset needed (latin is always included) and enter the right font weight or the font will not displayed.';

$string['fontname'] = 'Main font';
$string['fontnamedesc'] = 'Select the default font, \'sans-serif\', or <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> used in the site.';

$string['customfontname'] = 'Custom Main font';
$string['customfontnamedesc'] = 'Enter the name of the custom Main Font only if you selected &apos;Custom&apos; in the Main Font dropdown.';

$string['fontsize'] = 'Main font size';
$string['fontsizedesc'] = 'Select the default font size (in percentage) used in the whole site.';

$string['fontheadername'] = 'Headers font';
$string['fontheadernamedesc'] = 'Select the default font, \'sans-serif\', or <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> used in the text and blocks headers.';

$string['customfontheadername'] = 'Custom Header font';
$string['customfontheadernamedesc'] = 'Enter the name of the custom Header font only if you selected &apos;Custom&apos; in the Header Font dropdown.';

$string['fontcolor'] = 'Main font colour';
$string['fontcolordesc'] = 'Set the colour of the font in the theme, use html hex code.';

$string['fontheadercolor'] = 'Headers font colour';
$string['fontheadercolordesc'] = 'Set the colour of the headers font in the theme, use html hex code.';

$string['fontweight'] = 'Main font weight';
$string['fontweightdesc'] = 'Font weight used in site. Select a value from 100 to 900 depending the font selected.';

$string['fontheaderweight'] = 'Headers font weight';
$string['fontheaderweightdesc'] = 'Headers font weight used in the site. Select a value from 100 to 900 depending the font selected.';

$string['fonttitlename'] = 'Site / Course title font';
$string['fonttitlenamedesc'] = 'Select the default font, \'sans-serif\', or <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> used in title site and course titles.';

$string['customfonttitlename'] = 'Custom Title font';
$string['customfonttitlenamedesc'] = 'Enter the name of the custom Title Font only if you selected &apos;Custom&apos; in the Title Font dropdown.';

$string['fonttitlecolor'] = 'Site / Course title font colour';
$string['fonttitlecolordesc'] = 'Set the colour of the site title and course title font in the theme, use html hex code.';

$string['fonttitleweight'] = 'Site / Course title font weight';
$string['fonttitleweightdesc'] = 'Set the font weight used in the site title and course titles. Select a value from 100 to 900 depending the font selected.';

$string['fonttitlesize'] = 'Site / Course title font size';
$string['fonttitlesizedesc'] = 'Site title and course title font size used in site. Select a value fron the list.';

$string['fonttitlecolorcourse'] = 'Course title font colour';
$string['fonttitlecolorcoursedesc'] = 'Set the colour of the course title font in the theme, use html hex code.';

$string['fontsubset'] = 'Google Fonts subset';
$string['fontsubsetdesc'] = 'Select other character subset than latin to be applied to all the fonts. Latin subset is already included by default.';

$string['menufontsize'] = 'Font size for navigation bar';
$string['menufontsizedesc'] = 'Set the size of the font used in the main navigation bar.';

$string['menufontpadding'] = 'Padding for Navigation Items';
$string['menufontpaddingdesc'] = 'Set the padding of the items in the main navigation bar.';

$string['fontblockheadercolor'] = 'Blocks header font colour';
$string['fontblockheadercolordesc'] = 'Set the colour of the header font moodle blocks, use html hex code. Note that this affects icon colour too.';

$string['fontblockheaderweight'] = 'Blocks header font weight';
$string['fontblockheaderweightdesc'] = 'Set the font weight used in the moodle blocks header. Select a value from 100 to 900 depending the font selected.';

$string['fontblockheadersize'] = 'Blocks header font size';
$string['fontblockheadersizedesc'] = 'Set the font size used in the moodle blocks header. Select a value fron the list.';


// Icons ***********************************************************.
$string['blockicons'] = 'Block Icons';
$string['blockiconsdesc'] = 'Set this to show block icons in the block header area.';

$string['blockiconsheadersize'] = 'Blocks header icon size';
$string['blockiconsheadersizedesc'] = 'Set the font icon size used in the moodle blocks header. Select a value fron the list.';


// Buttons *********************************************************.
$string['buttonsettings'] = 'Buttons';
$string['buttonsettingsheading'] = 'Customize the buttons of this theme.';
$string['buttondesc'] = 'Alter the appearance of buttons used in this theme.';

$string['buttonradius'] = 'Set Button Radius';
$string['buttonradiusdesc'] = 'Higher radius = curved buttons, lower radius = square buttons';

$string['buttoncolor'] = 'Button colour';
$string['buttoncolordesc'] = 'The colour of the main buttons used throughout the site.';

$string['buttonhovercolor'] = 'Button colour (When hovering)';
$string['buttonhovercolordesc'] = 'The colour that the button changes to when hovering over the button.';

$string['buttontextcolor'] = 'Button text colour';
$string['buttontextcolordesc'] = 'The colour of text used on buttons';

$string['buttoncolorscnd'] = 'Secondary Button colour';
$string['buttoncolordescscnd'] = 'The colour of the secondary buttons used throughout the site.';

$string['buttonhovercolorscnd'] = 'Secondary Button colour (When hovering)';
$string['buttonhovercolordescscnd'] = 'The colour that the secondary button changes to when hovering over the button.';

$string['buttontextcolorscnd'] = 'Secondary Button text colour';
$string['buttontextcolordescscnd'] = 'The colour of text used on secondary buttons.';

$string['buttoncolorcancel'] = 'Cancel Button colour';
$string['buttoncolordesccancel'] = 'Background colour for Cancel button.<br />Type transparent in the box for transparency.';

$string['buttonhovercolorcancel'] = 'Cancel Button colour (When hovering)';
$string['buttonhovercolordesccancel'] = 'The colour that the cancel button changes to when hovering over the button. <br />Type transparent in the box for transparency.';

$string['buttontextcolorcancel'] = 'Cancel Button text colour';
$string['buttontextcolordesccancel'] = 'The colour of text used on cancel buttons.';

$string['editfont'] = 'Editing and Customize this page button font colour';
$string['editfontdesc'] = 'Set the Editing and Customize this page button font colour';

$string['editverticalpadding'] = 'Set vertical padding of editing buttons';
$string['edithorizontalpadding'] = 'Set Horizontal padding of editing buttons';

$string['buttondropshadow'] = 'Drop shadow decoration on bottom of button';
$string['buttondropshadowdesc'] = 'Show a drop shadow (shading) on bottom of button.';

// Login button.
$string['logintextbutton'] = 'Log In';

$string['buttonlogincolor'] = 'Login button colour';
$string['buttonlogincolordesc'] = 'The colour of the login button.';

$string['buttonloginhovercolor'] = 'Login button hover colour';
$string['buttonloginhovercolordesc'] = 'The hover colour of the login button.';

$string['buttonlogintextcolor'] = 'Login button text colour';
$string['buttonlogintextcolordesc'] = 'The colour of text used on the login button.';

$string['buttonloginpadding'] = 'Set Padding for Log In Button';
$string['buttonloginpaddingdesc'] = 'Higher number = bigger button';

$string['buttonloginheight'] = 'Set Height for Login Button';
$string['buttonloginheightdesc'] = 'Only effective if using a login form in the upper header';

$string['buttonloginmargintop'] = 'Set Top Margin for Login Button';
$string['buttonloginmargintopdesc'] = 'Allows spacing / position of login button to be altered';

$string['loginplaceholder'] = 'Username';
$string['passwordplaceholder'] = 'Password';


// Header ***********************************************************.
$string['headersettings'] = 'Header';
$string['headersettingsheading'] = 'Customize the header of this theme. See the layout <a href="./../theme/adaptable/pix/layout.png" target="_blank"> here</a>';
$string['headerdesc'] = 'Upload your favicon, logo, set login form in header, adjust titles in header.<br />
You can set font size and styles for titles in the <a href="./../admin/settings.php?section=theme_adaptable_font">fonts</a> settings page.';

$string['headerbgimage'] = 'Background image';
$string['headerbgimagedesc'] = 'Set a background image in the header. Minimum size is 1600x180px (1900x180px recommended). The image cover the full header. You can add a colour in &#39;Top header background colour&#39; or use <i>transparent</i> to show the background image. In that case, modify the text colour to get displayed correctly over the image.';

$string['enableheading'] = 'Header course title';
$string['enableheadingdesc'] = 'Set the mode to display the course title in the header when the default Moodle site title is enabled.';

$string['breadcrumbdisplay'] = 'Breadcrumb display';
$string['breadcrumbdisplaydesc'] = 'Set the display of what should be in the breadcrumb area in a course.';

$string['sitetitlecoursesdisabled'] = 'Disabled - only show course titles in course pages';
$string['sitetitlecoursesenabled'] = 'Enabled - show site title and course titles in course pages';

$string['sitetitlepadding'] = 'Site Title Padding';
$string['sitetitlepaddingdesc'] = 'Set padding for the site / course title e.g. 5px 10px 5px 10px (top, right, bottom, left).';

$string['sitetitlemaxwidth'] = 'Site Title Maximum Width';
$string['sitetitlemaxwidthdesc'] = 'Set the maximum width of the site title area';

$string['coursetitlemaxwidth'] = 'Course Title Maximum Length';
$string['coursetitlemaxwidthdesc'] = 'Set the maximum number of characters of the course title area';

$string['pageheaderheight'] = 'Page Header Height';
$string['pageheaderheightdesc'] = 'Set the height of the main header area (containing logo and titles)';

$string['coursepageheaderhidesitetitle'] = 'Hide site title on course pages';
$string['coursepageheaderhidesitetitledesc'] = 'Hide site title, logo and search bar on course pages. Use this along with page header height setting to show a smaller header on course-related pages.';

$string['breadcrumb'] = 'Breadcrumb';
$string['breadcrumbtitle'] = 'Breadcrumb course name';
$string['breadcrumbtitledesc'] = 'Set the mode to display the course title in the breadcrumb.';

$string['coursetitlefullname'] = 'Course Full Name';
$string['coursetitleshortname'] = 'Course Short Name / Code';

$string['headerstyleheading'] = 'Header Style Settings';
$string['headerstyleheadingdesc'] = 'Adaptable supports two header styles, the original three row header and a newer simplified two row header.
Be aware that if you switch to the newer two row header you will <strong>NOT</strong> be able to: <br />
<ol><li>Show social icons in the header</li><li>Display the site logo on mobile devices</li></ol>';

$string['headerstyle'] = 'Header style';
$string['headerstyledesc'] = 'Choose the style of header. Header 1 refers to the original 3 row Adaptable header.  Header 2 is a minimal 2 row header. Note that when using Header 2, for the setting "Use Search Box or Social Icons", this will always use a search box.';
$string['headerstyle1'] = 'Header 1 (original 3 row header)';
$string['headerstyle2'] = 'Header 2 (2 row header)';

$string['header2searchbox'] = 'Header 2 search box expandable';
$string['header2searchboxdesc'] = 'Disabled, static or expand and collapse functionality on the search box when using header 2.';

$string['socialorsearch'] = 'Use Search Box or Social Icons';
$string['socialorsearchdesc'] = 'You can set the theme to either display social icons or a search box in the header. <br />
You can set social icons under the <a href="./../admin/settings.php?section=theme_adaptable_social">Header Social</a> settings page</strong>.';

$string['socialorsearchnone'] = 'None';

$string['socialorsearchsocial'] = 'Display social icons in header';
$string['socialorsearchsearch'] = 'Display search box in header';

$string['searchboxpadding'] = 'Search box padding';
$string['searchboxpaddingdesc'] = 'Set padding above search box (if being used instead of social icons) <br />E.g. 5px 10px 5px 10px (top, right, bottom, left).<br> You can set social icons under the <a href="./../admin/settings.php?section=theme_adaptable_social">Header Social</a> settings page</strong>.';

$string['enablesavecanceloverlay'] = 'Enable Save / Cancel overlay on settings pages';
$string['enablesavecanceloverlaydesc'] = 'Display a Save / Cancel button overlay at the top of a settings page to make it easier to save settings.';

$string['usernavheading'] = 'Customize the user navigation dropdown';
$string['usernav'] = 'Header User';
$string['usernavdesc'] = 'Allows you to control all of the elements that appear in the user navigation dropdown.';

$string['showusername'] = 'Show username';
$string['showusernamedesc'] = 'Show the username on the user menu on the navbar.';

$string['usernameposition'] = 'User name position';
$string['usernamepositiondesc'] = 'Set the postion of the userame, \'Left\' or \'Right\'.';

$string['menusettings'] = 'Header Menus';
$string['menusettingsheading'] = 'Customize menus in the upper header the header of this theme.';

$string['logo'] = 'Logo';
$string['logodesc'] = 'Upload a logo for use on your site.  Recommended size is 200px by 80px.';

$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Upload a favicon for use on your site,';

$string['enableavailablecourses'] = 'Display "Available Courses"';
$string['enableavailablecoursesdesc'] = 'Display "Available Courses" text in the frontpage';

$string['thiscourse'] = 'This course';
$string['coursesections'] = 'Course sections';

$string['loadtime'] = 'Page loaded in';

$string['loadingcolor'] = 'Loading colour';
$string['loadingcolordesc'] = 'The loading bar colour in the top of the page';

$string['sitetitle'] = 'Display site title';
$string['sitetitledesc'] = 'Display the default Moodle site title from <a href="./../admin/settings.php?section=frontpagesettings" target="_blank">Front Page Settings</a> or enter a custom site title in the text box below. If you add a logo image then the title is not displayed.';

$string['sitetitleoff'] = 'Disable site title';
$string['sitetitledefault'] = 'Use Moodle site title (site name)';
$string['sitetitlecustom'] = 'Use custom site title (enter in text box below)';

$string['sitetitletext'] = 'Site title';
$string['sitetitletextdesc'] = 'Site title displayed in the header. You can use any HTML tag and apply inline styles. It is recommended to use an h1 HTML tag around the title, instead of the p tag that gets added as default when you type something in this field.';

$string['displaylogin'] = 'Display login';
$string['displaylogindesc'] = 'Select how to display the login box in header.';

$string['displayloginbutton'] = 'Button';
$string['displayloginbox'] = 'Login Box';
$string['displayloginno'] = 'No Login Box';

$string['hideblocks'] = 'Hide blocks';
$string['showblocks'] = 'Show blocks';
$string['fullscreen'] = 'Full screen';
$string['standardview'] = 'Standard view';
$string['sitelinkslabel'] = 'Site links';

$string['enablezoom'] = 'Enable Zoom';
$string['enablezoomdesc'] = 'Allow users to toggle between fullscreen and fixed width.';
$string['enablezoomshowtext'] = 'Show text for Enable Zoom';
$string['enablezoomshowtextdesc'] = 'Shows the text beside the button.';

$string['defaultzoom'] = 'Default Zoom';
$string['defaultzoomdesc'] = 'Default screen size when enable zoom is disabled or the user has not made a preference.  Choose between fullscreen and fixed width.';
$string['normal'] = 'Fixed width';
$string['wide'] = 'Fullscreen';

$string['enableshowhideblocks'] = 'Enable Show Hide Blocks';
$string['enableshowhideblocksdesc'] = 'Allows users to show / hide all blocks.';
$string['enableshowhideblockstext'] = 'Show text for Show Hide Blocks';
$string['enableshowhideblockstextdesc'] = 'Shows the text beside the button.';

$string['enablenavbarwhenloggedout'] = 'Enable Navbar when logged out';
$string['enablenavbarwhenloggedoutdesc'] = 'Shows the navbar even when logged out. Limited to Help and Tools menu only.';

$string['fullscreenwidth'] = 'Full screen width.';
$string['fullscreenwidthdesc'] = 'Set the max width of the theme when it is in full screen mode / zoom.';

$string['standardscreenwidth'] = 'Standard screen width.';
$string['standardscreenwidthdesc'] = 'Set the width of the screen when toggled to "standard" view (also see related enablezoom and defaultzoom settings).';
$string['narrow'] = '1000px';
$string['standard'] = '1170px';

// Help Links ******************************************************.
$string['headernavbarhelpheading'] = 'Help Links and Options';
$string['headernavbarhelpheadingdesc'] = 'Options for help menu links.';

$string['helplinkscount'] = 'Number of help links';
$string['helplinkscountdesc'] = 'Set the number of help links you want to add to the main navigation bar.';

$string['enablehelp'] = 'Help Link \'{$a->number}\'';
$string['enablehelpdesc'] = 'Add a help link \'{$a->number}\' in the navbar.';

$string['helplinktitle'] = 'Help Link \'{$a->number}\' title';
$string['helplinktitledesc'] = 'The title for help link \'{$a->number}\' in the navbar.  If empty then defaults to \'Help {$a->number}\'.';

$string['helptitle'] = 'Help {$a->number}';

$string['helpprofilefield'] = 'Help link \'{$a->number}\' custom profile field (optional)';
$string['helpprofilefielddesc'] = 'Add help link \'{$a->number}\' access rule using for custom profile field eg: usertype=student';


// Courses Overlay *************************************************.
$string['rendereroverlaycolor'] = 'Overlay colour';
$string['rendereroverlaycolordesc'] = 'The colour of the overlay, when the "Tiles w/ overlay" renderer is selected.';

$string['rendereroverlayfontcolor'] = 'Overlay font colour';
$string['rendereroverlayfontcolordesc'] = 'The colour of the font, when hovering over a coursebox with "Tiles w/ overlay" renderer enabled.';

$string['covbkcolor'] = 'Coventry tiles title background colour';
$string['covbkcolordesc'] = 'Set the title background colour with the Coventry Tiles renderer is selected.';

$string['covfontcolor'] = 'Coventry tiles title font colour';
$string['covfontcolordesc'] = 'Set the title font colour with the Coventry Tiles renderer is selected.';

$string['covhidebutton'] = 'Coventry tiles course button';
$string['covhidebuttondesc'] = 'Set this to hide the course button when Coventry Tiles is selected.';

$string['frontpagerendererdefaultimage'] = 'Default course image';
$string['frontpagerendererdefaultimagedesc'] = 'The default image to use when no course image is found, (only applies for Tiles w/ overlay)';

$string['tilesshowcontacts'] = 'Show course contacts';
$string['tilesshowcontactsdesc'] = 'Show / hide course contacts';

$string['tilesbordercolor'] = 'Coursebox tiles border colour';
$string['tilesbordercolordesc'] = 'Set a colour for the coursebox tiles border';

$string['tilescontactstitle'] = 'Show course contacts role';
$string['tilescontactstitledesc'] = 'Show / hide the role of a course contact. If not displayed, an image will be displayed before each contact';

$string['tilesshowallcontacts'] = 'Show all course contacts';
$string['tilesshowallcontactsdesc'] = 'Show all course contacts or just one';

$string['course'] = 'Course';


// Alerts **********************************************************.
// Alert message if acting as another role.
$string['actingasrole'] = 'You are currently acting as a different role';

// Alert Hidden Course.
$string['alerthiddencourse'] = 'Hidden course warning';
$string['alerthiddencoursedesc'] = 'Display alert in course page if it is hidden';

$string['alerthiddencoursetext-1'] = 'This course is hidden and cannot be accessed by students. ';
$string['alerthiddencoursetext-2'] = 'Click here to update settings';

// Alert Box Enable.
$string['enablealert'] = 'Enable Alert Box {$a}';
$string['enablealertdesc'] = 'Enable Alert Box {$a}';

// Alert Box Generic Strings.
$string['alerttype'] = 'Alert Box Type';
$string['alerttypedesc'] = 'Select the type of alert: info (blue), warning (yellow) or announcement (green)';

$string['alerttext'] = 'Alert text';
$string['alerttextdesc'] = 'Enter the text to display in the Alert box';

$string['enablealerts'] = 'Enable / Disable Alerts';
$string['enablealertsdesc'] = 'Enable / disable alerts on your site';

$string['enablealertcoursepages'] = 'Enable Alert Box on Course Pages';
$string['enablealertcoursepagesdesc'] = 'Turning this option on will display the top alert box in the courses pages';

$string['enablealertstriptags'] = 'Automatically strip html tags from alerts';
$string['enablealertstriptagsdesc'] = 'Enable will clean up alert messages automatically, Disable will allow you to use html / links in messages but you will have to clean up manually in html view';

$string['alertkeyvalue'] = 'Alert Key';
$string['alertkeyvalue_details'] = 'The key that identifies this alert, from previous alerts. If you change this, all users who have dismissed the alert previously will see it again. If you change the alert, you will likely want to change this to ensure all users see it.';

$string['alertsettingscourse'] = 'Course Alert Settings';

$string['alertsettingsgeneral'] = 'General Alert Settings';
$string['alertsettings'] = 'Alert Box {$a}';

$string['alertcount'] = 'Alert count';
$string['alertcountdesc'] = 'The number of alerts to show in the edit area below.';

$string['alertsettingsheading'] = 'Customize top Alert Box. See the layout <a href="./../theme/adaptable/pix/layout.png" target="_blank"> here</a>';
$string['alertdesc'] = 'Enter and customize a text to be displayed in the top of the site as an alert. It is possible to set more than one alert to target different user types. You also have the option of showing alerts sitewide or on homepages only. <br /><br /><strong>Note:</strong> it is now also possible to display alerts within course pages to warn teachers that courses are hidden.';

// Alerts Types.
$string['alertdisabled'] = 'Disabled';
$string['alertdisabledesc'] = 'Disable this alert.';

$string['alertinfo'] = 'Info';
$string['alertinfodesc'] = 'Display information in the Alert Box.';

$string['alertwarning'] = 'Warning';
$string['alertwarningdesc'] = 'Display a warning in the Alert Box.';

$string['alertannounce'] = 'Announcement';
$string['alertannouncedesc'] = 'Display an announcement in the Alert Box.';

$string['alertprofilefield'] = 'Custom Profile Field Name=Value (optional)';
$string['alertprofilefielddesc'] = 'Add access rule using for custom profile field eg: usertype=student';

// Alert Access - Visibility.
$string['alertaccessglobal'] = 'Visible to everyone';
$string['alertaccessusers'] = 'Visible to logged in users';
$string['alertaccessadmins'] = 'Visible to administrators';
$string['alertaccessprofile'] = 'Add custom profile field restriction';

$string['alertaccess'] = 'Alert Visibility';
$string['alertaccessdesc'] = 'Set access restriction type for alert box visibility. Note: if using "Add custom profile field restriction" you will need to add values for profile fields below.';

// Moodle/Adaptable version alert messages.
$string['beta'] = 'DEVELOPMENT VERSION. DO NOT USE IN PRODUCTION SITES';
$string['deprecated'] = 'MOODLE DEPRECATED VERSION. DO NOT USE ADAPTABLE IN THIS SITE';

// Alerts Colors****************************************************.
$string['alertcolorsheading'] = 'Customize top Alert Boxes';
$string['alertcolorsheadingdesc'] = 'Set colours and icon.';

$string['alertcolorinfo'] = 'Info Colour';
$string['alertcolorinfodesc'] = 'Icon colour of the Info type alert boxes';
$string['alertbackgroundcolorinfo'] = 'Info Background Colour';
$string['alertbackgroundcolorinfodesc'] = 'Background colour of the Info type alert boxes';
$string['alertbordercolorinfo'] = 'Info Border Colour';
$string['alertbordercolorinfodesc'] = 'Border colour of the Info type alert boxes';
$string['alerticoninfo'] = 'Info Icon';
$string['alerticoninfodesc'] = 'Set the <a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome Icon</a> to be used in Info type alert boxes. Enter the icon name without the fa- prefix.';

$string['alertcolorwarning'] = 'Warning Colour';
$string['alertcolorwarningdesc'] = 'Icon colour of the Warning type alert boxes';
$string['alertbackgroundcolorwarning'] = 'Warning Background Colour';
$string['alertbackgroundcolorwarningdesc'] = 'Background colour of the Warning type alert boxes';
$string['alertbordercolorwarning'] = 'Warning Border Colour';
$string['alertbordercolorwarningdesc'] = 'Border colour of the Warning type alert boxes';
$string['alerticonwarning'] = 'Warning Icon';
$string['alerticonwarningdesc'] = 'Set the <a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome Icon</a> to be usedin in Warning type alert boxes. Enter the icon name without the fa- prefix.';

$string['alertcolorsuccess'] = 'Announcement Colour';
$string['alertcolorsuccessdesc'] = 'Icon colour of the Announcement type alert boxes';
$string['alertbackgroundcolorsuccess'] = 'Announcement Background Colour';
$string['alertbackgroundcolorsuccessdesc'] = 'Background colour of the Announcement type alert boxes';
$string['alertbordercolorsuccess'] = 'Announcement Border Colour';
$string['alertbordercolorsuccessdesc'] = 'Border colour of the Announcement type alert boxes';
$string['alerticonsuccess'] = 'Announcement Icon';
$string['alerticonsuccessdesc'] = 'Set the <a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome Icon</a> to be usedin in Announcement type alert boxes. Enter the icon name without the fa- prefix.';

// Mobile **********************************************************.
$string['responsivesettings'] = 'Layout Responsive';
$string['responsivesettingsheading'] = 'Control how your site behaves at different screen sizes';
$string['responsivesettingsdesc'] = 'Here you can control the responsive behaviour of your site (which elements appear on screens of different sizes).<br/>
    By default most non essential items are hidden on mobile devices, being set to appear only on larger screens.<br/>
    You can make elements appears on smaller screens by choosing to display them on "Extra Small" or "Small screens".<br/>
    To gain a better understanding of how these settings work please refer to the Bootstrap 4 documentation:<br/><br/>
    https://getbootstrap.com/docs/4.0/utilities/display/ <br/><br/>';

$string['responsivealerts'] = 'Alerts';
$string['responsivealertsdesc'] = 'What sized screens would you like alerts to be displayed on?';

$string['responsivesocial'] = 'Social Icons';
$string['responsivesocialdesc'] = 'What sized screens would you like social icons to be displayed on?';

$string['responsivecoursetitle'] = 'Course / Site Title';
$string['responsivecoursetitledesc'] = 'What sized screens would you like the Site / Course titles to be displayed on?';

$string['responsivesectionnav'] = 'Activity / Section Nagivation';
$string['responsivesectionnavdesc'] = 'Show / Hide the the <strong>text</strong> for "prev" "next" activty / section navigation on small screens.
        By default we hide this text on smaller screens so only the icons for <prev> <next> links display and not the full section / activity name.';

$string['responsivelogo'] = 'Logo';
$string['responsivelogodesc'] = 'What sized screens would you like the logo to be displayed on?';

$string['responsiveheader'] = 'Main Header';
$string['responsiveheaderdesc'] = 'What sized screens would you like the main header to be displayed on?<br/>
    This setting only applies if you are using the default / original 3 row header.<br/>
    Removing the header entirely will also remove elements contained within it:<br/>
    <ul><li>Social Icons</li><li>Logo</li><li>Site / Course Title</li></ul>';

$string['responsiveticker'] = 'News Ticker';
$string['responsivetickerdesc'] = 'What sized screens would you like the News Ticker to be displayed on?';

$string['responsivepagefooter'] = 'Footer';
$string['responsivepagefooterdesc'] = 'What sized screens would you like the Footer to be displayed on?';

$string['responsiveslider'] = 'Frontpage Slider';
$string['responsivesliderdesc'] = 'What sized screens would you like the Frontpage Slider to be displayed on?';

$string['responsivesearchicon'] = 'Show search icon';
$string['responsivesearchicondesc'] = 'Show search icon on small screen devices.';
$string['responsivebreadcrumb'] = 'Beadcrumb Navigation';
$string['responsivebreadcrumbdesc'] = 'What sized screens would you like Breadcrumb Navigation to be displayed on?';

// Bootstrap class descriptions used in array definitions.
$string['bs4all'] = 'Extra Small - Extra Large';
$string['bs4small'] = 'Small - Extra Large';
$string['bs4medium'] = 'Medium - Extra Large';
$string['bs4large'] = 'Large - Extra Large';
$string['bs4extralarge'] = 'Extra Large Only';
$string['bs4none'] = 'None';

// Layout **********************************************************.
$string['layoutsettings'] = 'Layout';
$string['layoutdesc'] = 'Set the default layout that users see.';
$string['layoutsettingsheading'] = 'Control aspects of the site\'s layout';

$string['blockside'] = 'Location of the blocks';
$string['blocksidedesc'] = 'Control whether blocks appear on the left or right of the page';

$string['rightblocks'] = 'Right side';
$string['leftblocks'] = 'Left side';

$string['sidebarnotlogged'] = 'Show sidebar when not logged';
$string['sidebarnotloggeddesc'] = 'Show the blocks sidebar when the user is not logged';

$string['emoticonsize'] = 'Emoticons size';
$string['emoticonsizedesc'] = 'Set the height and width of the moodle emoticons.';

$string['infoiconcolor'] = 'Help Icon colour';
$string['infoiconcolordesc'] = 'Set the colour of the info/help icon used by tooltips.';

$string['dangericoncolor'] = 'Warning Icon colour';
$string['dangericoncolordesc'] = 'Set the colour of the warning/danger icon mainly used in mandatory fields.';

$string['helptarget'] = 'Help target';
$string['helptargetdesc'] = 'Do you want the help link to open in a new window?';

$string['hideinforum'] = 'Hide Help and Tools in Forums';
$string['hideinforumdesc'] = 'When using fixed width and all menu options the forum search box spills onto the line below. Turning this option on will hide tools and help menu items in forums allowing it to display properly.';

$string['targetnewwindow'] = 'New window';
$string['targetsamewindow'] = 'Same window';

$string['toolsmenu2'] = '2nd Tools menu';
$string['toolsmenu2desc'] = 'You can configure links to be shown under a tools menu. Each line consists of some menu text, a link URL (optional), a tooltip title (optional) and a language code or comma-separated list of codes (optional, for displaying the line to users of the specified language only), separated by pipe characters. You can specify a structure using hyphens. For example:
<pre>
Moodle community|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de
Moodle.com|http://moodle.com/
</pre>';

$string['toolsmenulabel'] = 'Tools';
$string['toolsmenulabel2'] = 'Tools 2';
$string['events'] = 'Events';
$string['future'] = 'Future';
$string['hiddencourses'] = 'Hidden Courses';
$string['hiddenfromview'] = 'Hidden From View';
$string['inprogress'] = 'In Progress';
$string['mysites'] = 'My Courses';
$string['past'] = 'Past';
$string['pastcourses'] = 'Past Courses';
$string['people'] = 'Participants';
$string['help'] = 'Help';

$string['showfooterblocks'] = 'Show footer blocks';
$string['showfooterblocksdesc'] = 'Show / hide the four configurable footer blocks';

$string['breadcrumbseparator'] = 'Breadcrumb separator';
$string['breadcrumbseparatordesc'] = 'Set the <a href="https://fortawesome.github.io/Font-Awesome/icons/" target="_blank">Font Awesome Icon</a> to be used as item separator in the breadcrumb. enter the icon name without the fa- prefix.';

$string['breadcrumbhome'] = 'Breadcrumb home';
$string['breadcrumbhomedesc'] = 'Display home breadcrumb as an icon or as a text.';

$string['breadcrumbhometext'] = 'Text';
$string['breadcrumbhomeicon'] = 'Icon';

$string['mysitesexclude'] = 'Enable excluding hidden courses';
$string['mysitesinclude'] = 'Enable including hidden courses';
$string['mysitesdisabled'] = 'Disable';

$string['newstickercount'] = 'Number of News Ticker Sections';
$string['newstickercountdesc'] = 'Define multiple news ticker sections with access rules to target different audiences';

$string['tickertext'] = 'News Ticker Text';
$string['tickertextdesc'] = 'Add news ticker text in list format. See the read me for more info.';

$string['newmenu1trigger'] = 'Top Menu Dropdown 1 trigger word';
$string['newmenu1triggerdesc'] = 'Set a Top Menu Dropdown 1 trigger word. Font awesome icons can be used';

$string['menusheading'] = 'Configure Navigation for link Menus in the upper header';
$string['menustitledesc'] = 'Tools Menus (in navbar) and Top Menus (upper header) can be restricted based on custom profile fields (optional). To add a restriction enter the name of the profile field and expected value. Menu Structure follows the common Moodle format:
<pre>
Moodle community|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de
Moodle.com|http://moodle.com/
</pre>
';

$string['menusession'] = 'Store access details in session';
$string['menusessiondesc'] = 'For performance reasons it is suggested this is enabled. You may want to disable when testing';

$string['disablecustommenu'] = 'Disable Moodle Custom Menu';
$string['disablecustommenudesc'] = 'Disable Moodle Custom Menus in the navigation bar (will still render in other themes you may have installed)';

$string['menusessionttl'] = 'Minutes to store access rules in session';
$string['menusessionttldesc'] = 'Number of minutes after which menu access rules are refreshed in the users session.';


// Tool menus ******************************************************.
$string['newmenudesc'] = 'Configure links to be shown under a top header menu.';
$string['newmenufield'] = 'Custom Profile Field Name=Value (optional)';
$string['newmenufielddesc'] = 'Add access rule using for custom profile field eg: usertype=student';
$string['newmenurequirelogin'] = 'Require login';
$string['newmenurequirelogindesc'] = 'If enabled this menu will only be visible to logged in users';

$string['menusdesc'] = '';

$string['newmenu2trigger'] = 'Top Menu Dropdown 2 trigger word';
$string['newmenu2triggerdesc'] = 'Set a Top Menu Dropdown 2 trigger word. Font awesome icons can be used';

$string['enablemenus'] = 'Enable Menus';
$string['enablemenusdesc'] = 'It is recommended you leave this off if menus are not in use for preformance reasons';

$string['menuslinkright'] = 'Show menus link in topright';
$string['menuslinkrightdesc'] = 'If checked, show the link to the menus on the top right next to the messages menu';

$string['menuslinkicon'] = "Links menu icon";
$string['menuslinkicondesc'] = "Choose a custom font awesome icon.";

$string['disablemenuscoursepages'] = 'Disable Menus on Course Pages';
$string['disablemenuscoursepagesdesc'] = 'Turning this option on will limit the display of top menus to site pages, the homepage, and dashboard (My Home) etc. and will not show in any course pages';

$string['topmenufontsize'] = 'Top Menu Font Size';
$string['topmenufontsizedesc'] = 'Adjust the font size of the top menus';

$string['menuuseroverride'] = 'Allow user override';
$string['menuuseroverridedesc'] = 'These settings can be used to give users control over where menus appear via a custom profile field. To use this option you will need to create a custom profile field in the "list" format with values in the corresponding order:
<pre>1. Sitewide (the first item in the list will be for sitewide menu visibility)
2. Homepages Only (the second item in the list will set visibility to only site / homepages)
3. Hidden (the third value in the list will hide menus entirely)</pre>
You should NOT use the "Disable Menus on Course Pages" option in conjuction with profile field settings, instead use set the default value to your "Homepages Only" entry when setting up your profile field list.

Note: Users will have to log out of Moodle and back in again for this change to take effect, you may want to add a note explaining this in the custom profile field.';

$string['menuoverrideprofilefield'] = 'Custom profile field name';
$string['menuoverrideprofilefielddesc'] = 'The name of the custom profile "list" field used for user override';
$string['menuoverrideprofilefielddefault'] = 'topmenusettings';

$string['topmenuscount'] = 'Number of top Menus';
$string['topmenuscountdesc'] = 'Set the number of top menus you want to add to the theme header';

$string['menusheadingvisibility'] = 'General settings for Top Menu visibility';
$string['menusheadingvisibilitydesc'] = 'The following settings allow you to control where menus appear and optionally allow users to customise their settings';

$string['newmenuheading'] = 'Top Menu';
$string['newmenu'] = 'Top Menu Dropdown';
$string['newmenutitle'] = 'Top Menu Title';
$string['newmenutitledesc'] = 'The title of the dropdown list that will appear in the header of your site';
$string['newmenutitledefault'] = 'Menu';

$string['enabletoolsmenus'] = 'Enable Tools Menus';
$string['enabletoolsmenusdesc'] = 'It is recommended you leave this off if menus are not in use for preformance reasons';

$string['toolsmenuheading'] = 'Tools Menus (in main nagivation)';
$string['toolsmenuheadingdesc'] = 'You can configure links to be shown under a tools menu (in main navigation bar).
 The format is similar to that used for Moodle custom menus but allows you to add fa icons to menu items:
<pre>
&lt;span class=&quot;fa fa-video-camera&quot;&gt;&lt;/span&gt; Record Screen|http://google.co.uk|Record Screen
&lt;span class=&quot;fa fa-picture-o&quot;&gt;&lt;/span&gt; ThinkStock|http://google.co.uk|ThinkStock
&lt;span class=&quot;fa fa-clock-o&quot;&gt;&lt;/span&gt; Exam Clock|http://google.co.uk|Exam Clock
</pre><br />';

$string['toolsmenuscount'] = 'Number of tools Menus';
$string['toolsmenuscountdesc'] = 'Set the number of tools menus you want to add to the main navigation bar';

$string['toolsmenuheading'] = 'Tools Menu ';
$string['toolsmenu'] = 'Tools Menu Dropdown';
$string['toolsmenudesc'] = 'Add a drop down menu to the main navigation bar';
$string['toolsmenutitle'] = 'Tools Menu Title';
$string['toolsmenutitledefault'] = 'Tools';
$string['toolsmenutitledesc'] = 'Add the title of the menu you would like to display in the main navigation bar';

$string['toolsmenulabel'] = 'Tools Menu';

$string['toolsmenufield'] = 'Custom Profile Field Name=Value (optional)';
$string['toolsmenufielddesc'] = 'Add access rule using for custom profile field eg: usertype=student';


// Social settings *************************************************.
$string['socialsettings'] = 'Header Social';
$string['socialheading'] = 'Social Icon Settings';
$string['socialtitledesc'] = 'You can disable the sitewide search box and enable social icons / links in its place.
To setup icons enter a delimited list into the "Social Icon List" field below.
This should be in the format:

url|title|icon

For example:
<pre>
https://example.com/course/search.php|Search Moodle|fa-search
https://facebook.com/|Facebook|fa-facebook-square
https://twitter.com/|Twitter|fa-twitter-square
https://instagram.com|Instagram|fa-instagram
https://example.com|My Web|fa-globe
</pre>
For reference you can find the full list of <a href="https://fortawesome.github.io/Font-Awesome/icons/">Font Awesome Icons Here</a>';

$string['socialsize'] = 'Set the font size of the social icons';
$string['socialsizedesc'] = 'For a better view, the size needs to be 5px greater than the desired actual size.';
$string['responsivesocialsize'] = 'Set the font size of the social icons on Mobile';
$string['responsivesocialsizedesc'] = 'For a better view, the size needs to be 5px greater than the desired actual size.';
$string['socialpaddingside'] = 'Adjust padding for the side of the social icon';
$string['socialpaddingsidedesc'] = 'This will be space between the icon and another element or the gap between two icons.  i.e. the padding on the icon will be this value divided by two.  Default value follows Instagram branding guidelines.';
$string['socialpaddingtop'] = 'Adjust padding above social icons (alters vertical position)';
$string['socialpaddingtopdesc'] = 'This will be the minimum of 15px (set using the margin) plus this value.';

$string['socialtarget'] = 'Social Links Open Target';
$string['socialtargetdesc'] = 'How would you like social links to open (same or new window)';

$string['socialsearchicon'] = 'Search Moodle';
$string['socialsearchicondesc'] = 'Enable to put a search link alongside social icons (as using social disables sitewide search box)';

$string['socialicondesc'] = 'Set Font Awesome icon for example: fa-facebook';

$string['socialiconlist'] = 'Social Icon List';
$string['socialiconlistdesc'] = 'Enter a delimited list to setup the social icons / links you need using the format: url|title|icon';

// Templates.
$string['templatessettings'] = 'Templates';
$string['templatesheading'] = 'Templates Settings';
$string['templatesheadingdesc'] = 'Override templates';
$string['templatessel'] = 'Templates to override';
$string['templatesseldesc'] = 'Select the templates to override, then each will be shown on their own page.  If not selected here, then the template will not be overridden even if it is enabled.  To select none, use the \'Ctrl\' key.';
$string['overridetemplate'] = 'Override template: {$a}';
$string['activatetemplateoverride'] = 'Activate template override for \'{$a}\'';
$string['activatetemplateoverridedesc'] = 'When ticked then the value in the \'{$a->setting}\' setting will be used as the \'{$a->template}\' template if it contains text.';
$string['overriddentemplate'] = 'Overridden template: {$a}';
$string['overriddentemplatedesc'] = 'If set then the text here will be used as the template \'{$a}\'.  To ensure that the preview works, there needs to be the standard example context in JSON format.';
$string['overriddentemplatepreview'] = 'Setting overridden preview';
$string['overriddentemplatenopreview'] = 'No preview because of missing JSON example';
$string['originaltemplatepreview'] = 'Original / overridden theme file preview';
$string['originaltemplatesource'] = 'Original / overridden theme file source';

// Analytics *********************************.
$string['analyticssettings'] = 'Analytics';
$string['analyticssettingsheading'] = 'Setup Google Analytics and/or Matomo';
$string['analyticssettingsdesc'] = 'You can setup multiple codes for Google Analytics and targed them to user profile fields. Or you can use Matomo, the open source analytics.';

// GA.
$string['googleanalyticssettings'] = 'Google Analytics';
$string['googleanalyticssettingsheading'] = 'Setup Google Analytics for your site';
$string['googleanalyticssettingsdesc'] = 'You can setup multiple codes for Google Analytics and targed them to user profile fields.';

$string ['enableanalytics'] = 'Enable Google Analytics';
$string ['enableanalyticsdesc'] = 'Enable Google Analytics settings on your Moodle site';

$string ['analyticstext'] = 'Analytics ID';
$string ['analyticstextdesc'] = 'Enter Google Analytics ID';

$string['analyticscount'] = 'Analytics count';
$string['analyticscountdesc'] = 'The number of analytics fields to show in the edit area below.';

$string ['analyticsprofilefield'] = 'Custom Profile Field Name=Value (optional)';
$string ['analyticsprofilefielddesc'] = 'Add access rule using for custom profile field eg: usertype=student';

$string ['anonymizega'] = 'Anonymize the user IP';
$string ['anonymizegadesc'] = 'Anonymize the user IP send to Google Analytics';

// Matomo (formerly Piwik).
$string['piwiksettings'] = 'Matomo (formely Piwik) Analytics';
$string['piwiksettingsheading'] = 'Setup Matomo';
$string['piwiksettingsdesc'] = 'Generate clean URL for in advanced tracking.';

$string['piwikenabled'] = 'Enabled';
$string['piwikenableddesc'] = 'Enable Matomo tracking for Moodle.';

$string['piwiksiteid'] = 'Site ID';
$string['piwiksiteiddesc'] = 'Enter your Site ID.';

$string['piwikimagetrack'] = 'Image Tracking';
$string['piwikimagetrackdesc'] = 'Enable Image Tracking for Moodle for browsers with JavaScript disabled.';

$string['piwiksiteurl'] = 'Matomo URL';
$string['piwiksiteurldesc'] = 'Enter your Matomo Analytics URL without http(s) or a trailing slash';

$string['piwiktrackadmin'] = 'Tracking Admins';
$string['piwiktrackadmindesc'] = 'Enable tracking of Admin users (not recommended)';


// Custom CSS and Javascript ********************************.
$string['customcss'] = 'Custom CSS';
$string['customcssdesc'] = 'Whatever CSS rules you add to this textarea will be reflected in every page, making for easier customization of this theme.';

$string['customcssjssettings'] = 'Custom CSS & JS';
$string['genericsettingsheading'] = 'Apply your own modifications';
$string['genericsettingsdescription'] = 'Here you can find various settings to add your own CSS and JavaScript code to the theme.';

$string['jssection'] = 'Javascript Section';
$string['jssectiondesc'] = 'Add javascript code to the site.';

$string['jssectionrestricted'] = 'Conditional Javascript Section';
$string['jssectionrestricteddesc'] = 'Add javascript code to the site conditionally based on a custom profile field. This javascript will only appear if this condition is met.';

$string['jssectionrestrictedprofilefield'] = 'Javascript Section custom profile field';
$string['jssectionrestrictedprofilefielddesc'] = 'Show the javascript above ONLY when user matches this custom profile field value, eg: faculty=fbl.';

$string['jssectionrestricteddashboardonly'] = 'Include Javascript only on dashboard page';
$string['jssectionrestricteddashboardonlydesc'] = 'Show the javascript only on the dashboard page. Otherwise this displays sitewide.';

// Cache definitions.
$string['cachedef_userdata'] = 'A session cache used to store user specific data.';

// Activity and section navigation ********************************.
$string['nextactivity'] = 'Next Activity';
$string['previousactivity'] = 'Previous Activity';

$string['nextsection'] = 'Next Section';
$string['previoussection'] = 'Previous Section';

$string['maincoursepage'] = 'Main Course Page';
$string['jumpto'] = 'Jump to...';

// General ******************************************.
$string['hide'] = 'Hide';
$string['show'] = 'Show';

// Navbar Links menu *********************************.
$string['linksmenu'] = 'Links Menu';

// Navbar user menu *********************************.
$string['usermenu'] = 'User menu';

// Save / Discard button text *********************************.
$string['savebuttontext'] = 'Save changes';
$string['discardbuttontext'] = 'Cancel';

// Activity settings.
$string['activitiesheading'] = 'Activities';
$string['introboxbackgroundcolor'] = 'Intro Box background color';
$string['introboxbackgroundcolordesc'] = 'Background colour for the intro box (highlights activity description) used in forums and other activities';

// Forum settings.
$string['settingsforumheading'] = 'Forum';
$string['forumheaderbackgroundcolor'] = 'Forum post header background';
$string['forumheaderbackgroundcolordesc'] = 'Background colour for a Forum post';
$string['forumbodybackgroundcolor'] = 'Forum post body background';
$string['forumbodybackgroundcolordesc'] = 'Background colour for a Forum post';

// Course page further information *********************.
// Activity display *********************************.
$string['answered'] = 'Answered';
$string['attempted'] = 'Attempted';
$string['contributed'] = 'Contributed';
$string['draft'] = 'Not published to students';
$string['due'] = 'Due {$a}';
$string['feedbackavailable'] = 'Feedback available';
$string['notanswered'] = 'Not answered';
$string['notattempted'] = 'Not attempted';
$string['notcontributed'] = 'Not contributed';
$string['notsubmitted'] = 'Not Submitted';
$string['overdue'] = 'Overdue';
$string['reopened'] = 'Reopened';
$string['submitted'] = 'Submitted';

$string['xofyanswered'] = '{$a->completed} of {$a->participants} Answered';
$string['xofyattempted'] = '{$a->completed} of {$a->participants} Attempted';
$string['xofycontributed'] = '{$a->completed} of {$a->participants} Contributed';
$string['xofysubmitted'] = '{$a->completed} of {$a->participants} Submitted';
$string['xungraded'] = '{$a} Ungraded';

$string['coursesectionactivityfurtherinformation'] = 'Course page further information';
$string['coursesectionactivityfurtherinformationassign'] = 'Show Assignment information';
$string['coursesectionactivityfurtherinformationassigndesc'] = 'Show assignment information, such as due date, submission status.  For teachers / admins, show number of submissions.';
$string['coursesectionactivityfurtherinformationquiz'] = 'Show quiz information';
$string['coursesectionactivityfurtherinformationquizdesc'] = 'Show quiz information, such as submission status.  For teachers / admins, show number of submissions.';
$string['coursesectionactivityfurtherinformationchoice'] = 'Show choice information';
$string['coursesectionactivityfurtherinformationchoicedesc'] = 'Show choice information, such as submission status.  For teachers / admins, show number of submissions.';
$string['coursesectionactivityfurtherinformationfeedback'] = 'Show feedback information';
$string['coursesectionactivityfurtherinformationfeedbackdesc'] = 'Show feedback information, such as submission status.  For teachers / admins, show number of submissions.';
$string['coursesectionactivityfurtherinformationlesson'] = 'Show lesson information';
$string['coursesectionactivityfurtherinformationlessondesc'] = 'Show lesson information, such as submission status.  For teachers / admins, show number of submissions.';
$string['coursesectionactivityfurtherinformationdata'] = 'Show database information';
$string['coursesectionactivityfurtherinformationdatadesc'] = 'Show data information, such as submission status.  For teachers / admins, show number of submissions.';

// Activity display margins.
$string['coursesectionactivitymargintop'] = 'Top margin activity spacing';
$string['coursesectionactivitymargintopdesc'] = 'Top margin spacing between activities';
$string['coursesectionactivitymarginbottom'] = 'Bottom margin activity spacing.';
$string['coursesectionactivitymarginbottomdesc'] = 'Bottom margin spacing between activities.';

// Properties.
$string['properties'] = 'Import / Export Settings';
$string['propertiessub'] = 'Current theme settings';
$string['propertiesdesc'] = 'In this section you can import / export current Adaptable theme settings (properties) in JSON format. You can also view all current settings on this Moodle installation.';
$string['propertiesproperty'] = 'Property';
$string['propertiesvalue'] = 'Value';
$string['propertiesexport'] = 'Export properties as a JSON string';
$string['propertiesreturn'] = 'Return';
$string['putpropertiesheading'] = 'Import theme settings';
$string['putpropertiesname'] = 'Import properties';
$string['putpropertiesdesc'] = 'Paste the JSON string and \'Save changes\'.  Warning!  Does not validate setting values and performs a \'Purge all caches\'.';
$string['putpropertyreport'] = 'Report:';
$string['putpropertyversion'] = 'version:';
$string['putpropertyproperties'] = 'Properties';
$string['putpropertyour'] = 'Our';
$string['putpropertiesignorecti'] = 'Ignoring all course title image settings.';
$string['putpropertiesreportfiles'] = 'Remember to upload the following files to their settings:';
$string['putpropertiessettingsreport'] = 'Settings report:';
$string['putpropertiesvalue'] = '->';
$string['putpropertiesfrom'] = 'from';
$string['putpropertieschanged'] = 'Changed:';
$string['putpropertiesunchanged'] = 'Unchanged:';
$string['putpropertiesadded'] = 'Added:';
$string['putpropertiesignored'] = 'Ignored:';

// Privacy.
$string['privacy:metadata'] = 'Adaptable do not store any individual user data.';

// Adaptable Tabbed layout changes.
$string['tabbedlayoutheading'] = 'Adaptable Tabbed Layout';
$string['tabbedlayoutcoursepage'] = 'Course page Tabbed Layout';
$string['tabbedlayoutcoursepagedesc'] = 'Use a tabbed layout for the course page.  This displays all content in tabs, with course content in one tab and allowing you to tailor the content in other tabs. Use this setting to configure the order of tabs.';
$string['tabbedlayoutcoursepagelink'] = 'Course page Tabbed Layout course link';
$string['tabbedlayoutcoursepagelinkdesc'] = 'Have a tab link back to the course page in the course tabs.';
$string['tabbedlayoutcoursepagetabcolorselected'] = 'Selected tab colour for course page';
$string['tabbedlayoutcoursepagetabcolorselecteddesc'] = 'Choose the colour for the currently selected tab.';
$string['tabbedlayoutcoursepagetabcolorunselected'] = 'Unselected tab colour for course page';
$string['tabbedlayoutcoursepagetabcolorunselecteddesc'] = 'Choose the colour for any other tab.';
$string['tabbedlayoutcoursepagetabpersistencetime'] = 'Course homepage Tab persistence time';
$string['tabbedlayoutcoursepagetabpersistencetimedesc'] = 'Course homepage Tab persists on the selected tab when refreshing for a period of inactivity.  Set the inactivity period here.  For example, set to 30 so that the first tab is selected after 30 minutes of inactivity';
$string['tabbedlayoutdashboard'] = 'Dashboard page Tabbed Layout';
$string['tabbedlayoutdashboarddesc'] = 'Use a tabbed layout for the Dashboard page.  This displays all content in tabs, with course content in one tab and allowing you to tailor the content in other tabs. Use this setting to configure the order of tabs.';
$string['tabbedlayoutdashboardtabcolorselected'] = 'Selected tab colour for dashboard';
$string['tabbedlayoutdashboardtabcolorselecteddesc'] = 'Choose the colour for the currently selected tab.';
$string['tabbedlayoutdashboardtabcolorunselected'] = 'Unselected tab colour for dashboard';
$string['tabbedlayoutdashboardtabcolorunselecteddesc'] = 'Choose the colour for any other tab.';
$string['tabbedlayoutdashboardtab1condition'] = 'Tab 1 Custom Profile Field Restriction (optional)';
$string['tabbedlayoutdashboardtab1conditiondesc'] = 'Add access rule for displaying Tab 1 using custom profile field eg: showtab1=true';
$string['tabbedlayoutdashboardtab2condition'] = 'Tab 2 Custom Profile Field Restriction (optional)';
$string['tabbedlayoutdashboardtab2conditiondesc'] = 'Add access rule for displaying Tab 2 using custom profile field eg: showtab2=true';

$string['tabbedlayouttablabelcourse'] = 'Course Content';
$string['tabbedlayouttablabelcourse1'] = 'Tab 1';
$string['tabbedlayouttablabelcourse2'] = 'Tab 2';
$string['tabbedlayouttablabeldashboard'] = 'Dashboard Content';
$string['tabbedlayouttablabeldashboard1'] = 'Tab 1';
$string['tabbedlayouttablabeldashboard2'] = 'Tab 2';

$string['region-course-tab-one-a'] = 'Course page tab region 1';
$string['region-course-tab-two-a'] = 'Course page tab region 2';
$string['region-my-tab-one-a'] = 'Dashboard page tab region 1';
$string['region-my-tab-two-a'] = 'Dashboard page tab region 2';

// Number of course tiles in front page.
$string['frontpagenumbertiles'] = 'Number of course tiles per row';
$string['frontpagenumbertilesdesc'] = 'Number of course tiles to display per row in the front page courses list';
$string['frontpagetiles1'] = '1 tile';
$string['frontpagetiles2'] = '2 tiles';
$string['frontpagetiles3'] = '3 tiles';
$string['frontpagetiles4'] = '4 tiles';
$string['frontpagetiles6'] = '6 tiles';

// Edit settings.
$string['editsettingsbutton'] = 'Edit settings and Button display';
$string['editsettingsbuttondesc'] = 'Configure here what should appear in the Navbar for editing settings.  Note that these options do not apply to pages for which there are no related settings, such as the dashboard page.';
$string['editsettingsbuttonshowcog'] = 'Show edit settings icon (cog / gear wheel icon) only.';
$string['editsettingsbuttonshowbutton'] = 'Show edit button only. E.g. "Turn Editing on" button on course page.';
$string['editsettingsbuttonshowcogandbutton'] = 'Show edit settings icon and cog.  Note that this takes up more space in navigation.';
$string['displayeditingbuttontext'] = 'Editing button text';
$string['displayeditingbuttontextdesc'] = 'Show or hide the text on the editing button.  Note: Only applies to the course editing button.';

// Login *******************************************************.
$string['loginsettings'] = 'Login Page';
$string['loginsettingsheading'] = 'Customize the login page';
$string['logindesc'] = 'Customize the login page with adding an image background and texts above and below the login box.';


$string['loginsettingsheading'] = 'Customize the login page.';
$string['loginbgimage'] = 'Background image';
$string['loginbgimagedesc'] = 'Add a background image to the full size page.';
$string['loginbgstyle'] = 'Login background style';
$string['loginbgstyledesc'] = 'Select the style for the uploaded image.';
$string['loginbgopacity'] = 'Login page header, navbar, login box and footer background opacity when there is a background image';
$string['loginbgopacitydesc'] = 'Login background opacity for the header, navbar, login box and footer when there is a background image.';
$string['loginheader'] = 'Login page header';
$string['loginheaderdesc'] = 'Show the login page header.';
$string['loginfooter'] = 'Login page footer';
$string['loginfooterdesc'] = 'Show the login page footer.';
$string['logintextboxtop'] = 'Top text box';
$string['logintextboxtopdesc'] = 'Add a custom text above the login box.';
$string['logintextboxbottom'] = 'Bottom text box';
$string['logintextboxbottomdesc'] = 'Add a custom text below the login box.';

$string['stylecover'] = 'Cover';
$string['stylestretch'] = 'Stretch';

// User profile.
$string['aboutme'] = 'About me';
$string['course'] = 'Course';
$string['courses'] = 'Courses';
$string['more'] = 'More';

// User & user profile settings.
$string['usersettings'] = 'User Profile';
$string['usersettingsdesc'] = 'Set settings for the user profile.';
$string['usersettingsheading'] = 'Control aspects of the user profile';
$string['customcoursetitle'] = 'Custom course title';
$string['customcoursetitledesc'] = 'Name of the user profile custom field for the course title.';
$string['customcoursesubtitle'] = 'Custom course title';
$string['customcoursesubtitledesc'] = 'Name of the user profile custom field for the course title.';
$string['customfields'] = 'Custom fields';
$string['enabletabbedprofile'] = 'Enable tabbed profile';
$string['enabletabbedprofiledesc'] = 'Enable the tabbed profile functionality.';
$string['enabledtabbedprofileeditprofilelink'] = 'Enable edit profile link';
$string['enabledtabbedprofileeditprofilelinkdesc'] = 'Enable the tabbed profile edit profile link.  Note: When enabled will only show if the viewing user has permission to edit the profile.';
$string['enabledtabbedprofileuserpreferenceslink'] = 'Enable preferences link';
$string['enabledtabbedprofileuserpreferenceslinkdesc'] = 'Enable the tabbed profile user preferences link.';

$string['usernodescription'] = 'User has not updated their description yet.';
$string['usernointerests'] = 'User has not updated their interests yet.';

// Category headers settings.
$string['categoryheaderssettings'] = 'Category headers';
$string['categoryheaderssettingsdesc'] = 'Set settings for the headers within a category.';
$string['categoryheaderssettingsheading'] = 'Change the header for one or more top level categories and below.';

$string['categoryhavecustomheader'] = 'Category custom header';
$string['categoryhavecustomheaderdesc'] = 'Select the top level categories that will have a custom header.  To select more than one or deselect a category, use the \'Ctrl\' key.  Save and refesh the page to update  Note: Sub-categories of the selected will inherit the setting values.';
$string['categoryheaderheader'] = 'Settings for the top level category \'{$a->name}\' with id \'{$a->id}\'.';
$string['categoryheaderheaderdesc'] = 'Set the settings for the top level category \'{$a->name}\' with id \'{$a->id}\'.';
$string['categoryheaderheaderdescchildren'] = 'Set the settings for the top level category \'{$a->name}\' with id \'{$a->id}\' and its children \'{$a->children}\'.';
$string['categoryheaderbgimage'] = 'Category \'{$a->name}\' with id \'{$a->id}\' background image';
$string['categoryheaderbgimagedesc'] = 'Set a background image for the top level category \'{$a->name}\' with id \'{$a->id}\' in the header.  Minimum size is 1600x180px (1900x180px recommended).  The image will cover the full header.';
$string['categoryheaderbgimagedescchildren'] = 'Set a background image for the top level category \'{$a->name}\' with id \'{$a->id}\' and its children \'{$a->children}\' in the header.  Minimum size is 1600x180px (1900x180px recommended).  The image will cover the full header.';
$string['categoryheaderlogo'] = 'Category \'{$a->name}\' with id \'{$a->id}\' logo';
$string['categoryheaderlogodesc'] = 'Set a logo for the top level category \'{$a->name}\' with id \'{$a->id}\' in the header.  Recommended size is 200px by 80px.';
$string['categoryheaderlogodescchildren'] = 'Set a logo for the top level category \'{$a->name}\' with id \'{$a->id}\' and its children \'{$a->children}\' in the header.  Recommended size is 200px by 80px.';
$string['categoryheadercustomtitle'] = 'Category \'{$a->name}\' with id \'{$a->id}\' custom title';
$string['categoryheadercustomtitledesc'] = 'Set the custom title for the top level category \'{$a->name}\' with id \'{$a->id}\' in the header.  If blank then you will be presented with what has been configured by the \'sitetitle\' and \'sitetitletext\' settings on non-course pages or on course pages when \'enableheading\' is \'off\'.  When populated on non-course category linked pages then this will replace the site title.  When populated on course pages then will appear above the title as established by the \'enableheading\' setting.  But on mobiles any \'title\' will only appear depending on the \'responsivecoursetitle\' setting.';
$string['categoryheadercustomtitledescchildren'] = 'Set the custom title for the top level category \'{$a->name}\' with id \'{$a->id}\' and its children \'{$a->children}\' in the header.  If blank then you will be presented with what has been configured by the \'sitetitle\' and \'sitetitletext\' settings on non-course pages or on course pages when \'enableheading\' is \'off\'.  When populated on non-course category linked pages then this will replace the site title.  When populated on course pages then will appear above the title as established by the \'enableheading\' setting.  But on mobiles any \'title\' will only appear depending on the \'responsivecoursetitle\' setting.';
$string['categoryheadercustomcss'] = 'Category \'{$a->name}\' with id \'{$a->id}\' custom CSS';
$string['categoryheadercustomcssdesc'] = 'Set custom CSS for the top level category \'{$a->name}\' with id \'{$a->id}\'.  This will generate CSS for the theme selector prefixed with \'.category-{$a->id}\'.  If the CSS does not appear to be applied, then check the PHP log file.';
$string['categoryheadercustomcssdescchildren'] = 'Set custom CSS for the top level category \'{$a->name}\' with id \'{$a->id}\' and its children \'{$a->children}\'.  This will generate CSS for the theme selector prefixed with \'.category-{$a->id}\' and for all child ids.  If the CSS does not appear to be applied, then check the PHP log file.';
$string['invalidcategorycss'] = 'Invalid category custom CSS for category \'{$a->topcatname}\' with id \'{$a->topcatid}\': \'{$a->css}\'.';
$string['invalidcategorygeneratedcss'] = 'Invalid category custom generated CSS: \'{$a->css}\'.';
